/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import org.nuxeo.ecm.core.api.model.DeltaLong;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.sql.ACLRow;

public enum PropertyType {
    STRING(String.class),
    BOOLEAN(Boolean.class),
    LONG(Long.class),
    DOUBLE(Double.class),
    DATETIME(Calendar.class),
    BINARY(String.class),
    ACL(ACLRow.class),
    ARRAY_STRING(STRING, (Serializable[])new String[0]),
    ARRAY_BOOLEAN(BOOLEAN, new Boolean[0]),
    ARRAY_LONG(LONG, new Long[0]),
    ARRAY_DOUBLE(DOUBLE, new Double[0]),
    ARRAY_DATETIME(DATETIME, new Calendar[0]),
    ARRAY_BINARY(BINARY, (Serializable[])new String[0]),
    COLL_ACL(ACL, new ACLRow[0]);

    private final Class<?> klass;
    private final PropertyType arrayBaseType;
    private final Serializable[] emptyArray;

    private PropertyType(Class<?> klass) {
        this.klass = klass;
        this.arrayBaseType = null;
        this.emptyArray = null;
    }

    private PropertyType(PropertyType arrayBaseType, Serializable[] emptyArray) {
        this.klass = null;
        this.arrayBaseType = arrayBaseType;
        this.emptyArray = emptyArray;
    }

    public boolean isArray() {
        return this.arrayBaseType != null;
    }

    public PropertyType getArrayBaseType() {
        return this.arrayBaseType;
    }

    public Serializable[] getEmptyArray() {
        return this.emptyArray;
    }

    public Serializable[] collectionToArray(Collection<Serializable> collection) {
        Serializable[] array = (Serializable[])Array.newInstance(this.klass, collection.size());
        return collection.toArray(array);
    }

    public Serializable normalize(Object value) {
        if (value == null) {
            return null;
        }
        switch (this) {
            case STRING: {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new IllegalArgumentException("value is not a String: " + value);
            }
            case BOOLEAN: {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new IllegalArgumentException("value is not a Boolean: " + value);
            }
            case LONG: {
                if (value instanceof Long) {
                    return (Long)value;
                }
                if (value instanceof DeltaLong) {
                    return (DeltaLong)value;
                }
                throw new IllegalArgumentException("value is not a Long: " + value);
            }
            case DOUBLE: {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new IllegalArgumentException("value is not a Double: " + value);
            }
            case DATETIME: {
                if (value instanceof Calendar) {
                    return (Calendar)value;
                }
                if (value instanceof Date) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime((Date)value);
                    return cal;
                }
                throw new IllegalArgumentException("value is not a Calendar: " + value);
            }
            case BINARY: {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new IllegalArgumentException("value is not a binary String: " + value);
            }
            case ACL: {
                if (value instanceof ACLRow) {
                    return (ACLRow)value;
                }
                throw new IllegalArgumentException("value is not a ACLRow: " + value);
            }
        }
        throw new RuntimeException(this.toString());
    }

    public Serializable[] normalize(Object[] value) {
        if (value == null) {
            return this.emptyArray;
        }
        Serializable[] newValue = value instanceof Serializable[] ? (Serializable[])value : new Serializable[value.length];
        for (int i = 0; i < value.length; ++i) {
            newValue[i] = this.arrayBaseType.normalize(value[i]);
        }
        return newValue;
    }

    public static PropertyType fromFieldType(Type fieldType, boolean array) {
        if (fieldType instanceof StringType) {
            return array ? ARRAY_STRING : STRING;
        }
        if (fieldType instanceof BooleanType) {
            return array ? ARRAY_BOOLEAN : BOOLEAN;
        }
        if (fieldType instanceof LongType) {
            return array ? ARRAY_LONG : LONG;
        }
        if (fieldType instanceof DoubleType) {
            return array ? ARRAY_DOUBLE : DOUBLE;
        }
        if (fieldType instanceof DateType) {
            return array ? ARRAY_DATETIME : DATETIME;
        }
        if (fieldType instanceof BinaryType) {
            return array ? ARRAY_BINARY : BINARY;
        }
        if (fieldType instanceof IntegerType) {
            throw new RuntimeException("Unimplemented primitive type: " + fieldType.getClass().getName());
        }
        if (fieldType instanceof SimpleTypeImpl) {
            return PropertyType.fromFieldType(fieldType.getSuperType(), array);
        }
        throw new RuntimeException("Invalid primitive type: " + fieldType.getClass().getName());
    }
}

