/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;

public class XAResourceConnectionAdapter
implements XAResource {
    private static final Log log = LogFactory.getLog(XAResourceConnectionAdapter.class);
    protected JDBCConnection owner;
    protected Xid xid;

    public XAResourceConnectionAdapter(JDBCConnection connection) {
        this.owner = connection;
    }

    @Override
    public void start(Xid xid, int flag) throws XAException {
        if (flag == 0) {
            if (this.xid != null) {
                throw XAResourceConnectionAdapter.newXAException(-6, "Already started");
            }
        } else {
            throw XAResourceConnectionAdapter.newXAException(-5, "Invalid flag: " + flag);
        }
        this.xid = xid;
    }

    @Override
    public void end(Xid xid, int flag) throws XAException {
        if (xid != this.xid) {
            throw XAResourceConnectionAdapter.newXAException(-5, "Invalid Xid");
        }
        if (flag != 0x4000000 && flag != 0x20000000) {
            throw XAResourceConnectionAdapter.newXAException(-5, "Invalid flag: " + flag);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    @Override
    public void commit(Xid xid, boolean flag) throws XAException {
        if (this.xid == null || !this.xid.equals(xid)) {
            throw XAResourceConnectionAdapter.newXAException(-5, "Invalid Xid");
        }
        this.xid = null;
        try {
            this.owner.connection.commit();
        }
        catch (SQLException e) {
            throw XAResourceConnectionAdapter.newXAException(-3, "Cannot commit", e);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (this.xid == null || !this.xid.equals(xid)) {
            throw XAResourceConnectionAdapter.newXAException(-5, "Invalid Xid");
        }
        this.xid = null;
        try {
            this.owner.connection.rollback();
        }
        catch (SQLException e) {
            throw XAResourceConnectionAdapter.newXAException(-3, "Cannot rollback", e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        throw XAResourceConnectionAdapter.newXAException(-6, "Unsupported method");
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        return new Xid[0];
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int txTimeout) throws XAException {
        return false;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return this == xares;
    }

    protected static XAException newXAException(int errorCode, String message, Exception cause) {
        return (XAException)XAResourceConnectionAdapter.newXAException(errorCode, message).initCause(cause);
    }

    protected static XAException newXAException(int errorCode, String message) {
        XAException e = new XAException(message);
        e.errorCode = errorCode;
        return e;
    }
}

