/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class DurationUtils {
    public static final Pattern DURATION_SIMPLE_FORMAT = Pattern.compile("(?:(\\d+)d)?(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?(?:(\\d+)ms)?");

    private DurationUtils() {
    }

    public static Duration parse(String value) {
        if (value.startsWith("P") || value.startsWith("-P")) {
            return Duration.parse(value);
        }
        Matcher matcher = DURATION_SIMPLE_FORMAT.matcher(value);
        if (matcher.matches()) {
            long days = 0L;
            long hours = 0L;
            long minutes = 0L;
            long seconds = 0L;
            long millis = 0L;
            if (matcher.group(1) != null) {
                days = Long.parseLong(matcher.group(1));
            }
            if (matcher.group(2) != null) {
                hours = Long.parseLong(matcher.group(2));
            }
            if (matcher.group(3) != null) {
                minutes = Long.parseLong(matcher.group(3));
            }
            if (matcher.group(4) != null) {
                seconds = Long.parseLong(matcher.group(4));
            }
            if (matcher.group(5) != null) {
                millis = Long.parseLong(matcher.group(5));
            }
            return Duration.ofDays(days).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusMillis(millis);
        }
        throw new DateTimeParseException("Text cannot be parsed to a Duration", value, 0);
    }

    public static Duration parsePositive(String value, Duration defaultDuration) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultDuration;
        }
        try {
            Duration duration = DurationUtils.parse(value);
            if (duration.isZero() || duration.isNegative()) {
                return defaultDuration;
            }
            return duration;
        }
        catch (DateTimeParseException e) {
            return defaultDuration;
        }
    }
}

