/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.io.IOException;
import org.apache.xml.serialize.OutputFormat;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAccessor;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XMLBuilder;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XContent;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class XAnnotatedContent
extends XAnnotatedMember {
    private static final OutputFormat DEFAULT_FORMAT = new OutputFormat();

    public XAnnotatedContent(XMap xmap, XAccessor setter, XContent anno) {
        super(xmap, setter);
        this.path = new Path(anno.value());
        this.type = setter.getType();
        this.valueFactory = xmap.getValueFactory(this.type);
        this.xao = xmap.register(this.type);
    }

    @Override
    protected Object getValue(Context ctx, Element base) {
        boolean asDOM;
        Element el = (Element)DOMHelper.getElementNode((Node)base, this.path);
        if (el == null) {
            return null;
        }
        el.normalize();
        Node node = el.getFirstChild();
        if (node == null) {
            boolean asDOM2 = this.accessor.getType() == DocumentFragment.class;
            return asDOM2 ? null : "";
        }
        Range range = ((DocumentRange)((Object)el.getOwnerDocument())).createRange();
        range.setStartBefore(node);
        range.setEndAfter(el.getLastChild());
        DocumentFragment fragment = range.cloneContents();
        boolean bl = asDOM = this.accessor.getType() == DocumentFragment.class;
        if (asDOM) {
            return fragment;
        }
        try {
            return DOMSerializer.toString(fragment, DEFAULT_FORMAT);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void toXML(Object instance, Element parent) {
        String value;
        Object v = this.accessor.getValue(instance);
        if (v instanceof DocumentFragment) {
            Element e = XMLBuilder.getOrCreateElement(parent, this.path);
            DocumentFragment df = (DocumentFragment)v;
            Node node = e.getOwnerDocument().importNode(df, true);
            e.appendChild(node);
        } else if (this.valueFactory != null && v != null && (value = this.valueFactory.serialize(null, v)) != null) {
            Element e = XMLBuilder.getOrCreateElement(parent, this.path);
            DOMHelper.loadFragment(e, value);
        }
    }

    static {
        DEFAULT_FORMAT.setOmitXMLDeclaration(true);
        DEFAULT_FORMAT.setIndenting(true);
        DEFAULT_FORMAT.setMethod("xml");
        DEFAULT_FORMAT.setEncoding("UTF-8");
    }
}

