/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.util.List;
import java.util.Objects;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.platform.usermanager.GroupConfig;

public class NuxeoGroupImpl
implements NuxeoGroup {
    private static final long serialVersionUID = -69828664399387083L;
    protected DocumentModel model;
    protected GroupConfig config = GroupConfig.DEFAULT;

    public NuxeoGroupImpl(String name) {
        this(name, name);
    }

    public NuxeoGroupImpl(String name, String label) {
        if (name == null) {
            throw new IllegalArgumentException("group name cannot be null");
        }
        name = name.trim();
        label = label == null ? null : label.trim();
        this.model = SimpleDocumentModel.empty();
        this.model.setProperty(this.config.schemaName, this.config.idField, (Object)name);
        this.model.setProperty(this.config.schemaName, this.config.labelField, (Object)label);
    }

    public NuxeoGroupImpl(DocumentModel model, GroupConfig config) {
        this.model = model;
        this.config = config;
    }

    public List<String> getMemberUsers() {
        return (List)this.model.getProperty(this.config.schemaName, this.config.membersField);
    }

    public List<String> getMemberGroups() {
        return (List)this.model.getProperty(this.config.schemaName, this.config.subGroupsField);
    }

    public List<String> getParentGroups() {
        return (List)this.model.getProperty(this.config.schemaName, this.config.parentGroupsField);
    }

    public void setMemberUsers(List<String> users) {
        if (users == null) {
            throw new IllegalArgumentException("member users list cannot be null");
        }
        this.model.setProperty(this.config.schemaName, this.config.membersField, users);
    }

    public void setMemberGroups(List<String> groups) {
        if (groups == null) {
            throw new IllegalArgumentException("member groups list cannot be null");
        }
        this.model.setProperty(this.config.schemaName, this.config.subGroupsField, groups);
    }

    public void setParentGroups(List<String> groups) {
        if (groups == null) {
            throw new IllegalArgumentException("parent groups list cannot be null");
        }
        this.model.setProperty(this.config.schemaName, this.config.parentGroupsField, groups);
    }

    public String getName() {
        return (String)this.model.getProperty(this.config.schemaName, this.config.idField);
    }

    public void setName(String name) {
        this.model.setProperty(this.config.schemaName, this.config.idField, (Object)name);
    }

    public String getLabel() {
        String label = (String)this.model.getProperty(this.config.schemaName, this.config.labelField);
        return label == null ? this.getName() : label;
    }

    public void setLabel(String label) {
        this.model.setProperty(this.config.schemaName, this.config.labelField, (Object)label);
    }

    public DocumentModel getModel() {
        return this.model;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof NuxeoGroupImpl) {
            String name = this.getName();
            String otherName = ((NuxeoGroupImpl)other).getName();
            return Objects.equals(name, otherName);
        }
        return false;
    }

    public int hashCode() {
        String name = this.getName();
        return name == null ? 0 : name.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

