/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2ClientService;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.platform.oauth2.tokens.OAuth2TokenStore;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoOAuth2Authenticator
implements NuxeoAuthenticationPlugin {
    private static final Log log = LogFactory.getLog(NuxeoOAuth2Authenticator.class);
    public static final String ACCESS_TOKEN = "access_token";
    public static final String BEARER_SP = "Bearer ";
    protected OAuth2TokenStore tokenStore = new OAuth2TokenStore("org.nuxeo.server.token.store");

    public void initPlugin(Map<String, String> parameters) {
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return Boolean.FALSE;
    }

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        return Boolean.FALSE;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest request, HttpServletResponse response) {
        String accessToken = this.getAccessToken(request);
        if (accessToken == null) {
            log.trace((Object)"OAuth2 token not found");
            return null;
        }
        NuxeoOAuth2Token token = (NuxeoOAuth2Token)TransactionHelper.runInTransaction(() -> this.tokenStore.getToken(accessToken));
        OAuth2ClientService clientService = (OAuth2ClientService)Framework.getService(OAuth2ClientService.class);
        if (token == null) {
            log.trace((Object)"OAuth2 token unknown");
            return null;
        }
        if (token.isExpired()) {
            log.trace((Object)"OAuth2 token expired");
            return null;
        }
        if (!clientService.hasClient(token.getClientId())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("OAuth2 token for unknown client: " + token.getClientId()));
            }
            return null;
        }
        String username = token.getNuxeoLogin();
        log.trace((Object)("OAuth2 token found for user: " + username));
        return new UserIdentificationInfo(username);
    }

    protected String getAccessToken(HttpServletRequest request) {
        String accessToken = request.getParameter(ACCESS_TOKEN);
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            log.trace((Object)"Found access_token request parameter");
            return accessToken;
        }
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith(BEARER_SP)) {
            log.trace((Object)"Found Authorization: Bearer request header");
            return authorization.substring(BEARER_SP.length()).trim();
        }
        return null;
    }
}

