/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.providers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.HashMap;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class NuxeoOAuth2ServiceProviderWriter
extends ExtensibleEntityJsonWriter<NuxeoOAuth2ServiceProvider> {
    public static final String ENTITY_TYPE = "nuxeoOAuth2ServiceProvider";

    public NuxeoOAuth2ServiceProviderWriter() {
        super(ENTITY_TYPE, NuxeoOAuth2ServiceProvider.class);
    }

    protected void writeEntityBody(NuxeoOAuth2ServiceProvider provider, JsonGenerator jg) throws IOException {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        String principalName = this.ctx.getSession(null).getSession().getPrincipal().getName();
        NuxeoPrincipal principal = userManager.getPrincipal(principalName);
        jg.writeStringField("serviceName", provider.getServiceName());
        jg.writeStringField("description", provider.getDescription());
        jg.writeStringField("clientId", provider.getClientId());
        jg.writeStringField("clientSecret", principal.isAdministrator() ? provider.getClientSecret() : null);
        jg.writeStringField("authorizationServerURL", provider.getAuthorizationServerURL());
        jg.writeStringField("tokenServerURL", provider.getTokenServerURL());
        jg.writeStringField("userAuthorizationURL", provider.getUserAuthorizationURL());
        jg.writeArrayFieldStart("scopes");
        for (String scope : provider.getScopes()) {
            jg.writeString(scope);
        }
        jg.writeEndArray();
        jg.writeBooleanField("isEnabled", provider.isEnabled());
        jg.writeBooleanField("isAvailable", provider.isProviderAvailable());
        String authorizationURL = null;
        if (provider.getClientId() != null) {
            try {
                authorizationURL = provider.getAuthorizationUrl(this.ctx.getBaseUrl());
            }
            catch (IllegalArgumentException e) {
                authorizationURL = null;
            }
        }
        jg.writeStringField("authorizationURL", authorizationURL);
        NuxeoOAuth2Token token = this.getToken(provider, principalName);
        boolean isAuthorized = token != null;
        jg.writeBooleanField("isAuthorized", isAuthorized);
        jg.writeStringField("userId", isAuthorized ? token.getServiceLogin() : null);
    }

    private NuxeoOAuth2Token getToken(NuxeoOAuth2ServiceProvider provider, String nxuser) {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("serviceName", provider.getId());
        filter.put("nuxeoLogin", nxuser);
        return (NuxeoOAuth2Token)Framework.doPrivileged(() -> {
            DocumentModelList entries = provider.getCredentialDataStore().query(filter);
            if (entries != null) {
                if (entries.size() > 1) {
                    throw new NuxeoException("Found multiple " + provider.getId() + " accounts for " + nxuser);
                }
                if (entries.size() == 1) {
                    return new NuxeoOAuth2Token((DocumentModel)entries.get(0));
                }
            }
            return null;
        });
    }
}

