/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.jaxrs.io.operations.ExecutionRequest;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchFileEntry;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchHandler;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.automation.server.jaxrs.batch.handler.BatchFileInfo;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.web.common.RequestContext;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@WebObject(type="upload")
public class BatchUploadObject
extends AbstractResource<ResourceTypeImpl> {
    protected static final Log log = LogFactory.getLog(BatchUploadObject.class);
    protected static final String REQUEST_BATCH_ID = "batchId";
    protected static final String REQUEST_FILE_IDX = "fileIdx";
    protected static final String OPERATION_ID = "operationId";
    protected static final String REQUEST_HANDLER_NAME = "handlerName";
    public static final String UPLOAD_TYPE_NORMAL = "normal";
    public static final String UPLOAD_TYPE_CHUNKED = "chunked";
    public static final String KEY = "key";
    public static final String NAME = "name";
    public static final String MIMETYPE = "mimeType";
    public static final String FILE_SIZE = "fileSize";
    public static final String MD5 = "md5";
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;

    protected Map<String, String> mapWithName(String name) {
        return Collections.singletonMap(NAME, name);
    }

    @GET
    @Path(value="handlers")
    public Response handlers() throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        Set supportedHandlers = bm.getSupportedHandlers();
        List handlers = supportedHandlers.stream().map(this::mapWithName).collect(Collectors.toList());
        Map result = Collections.singletonMap("handlers", handlers);
        return this.buildResponse((Response.StatusType)Response.Status.OK, result);
    }

    @GET
    @Path(value="handlers/{handlerName}")
    public Response getHandlerInfo(@PathParam(value="handlerName") String handlerName) throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        BatchHandler handler = bm.getHandler(handlerName);
        if (handler == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, String> result = this.mapWithName(handler.getName());
        return this.buildResponse((Response.StatusType)Response.Status.OK, result);
    }

    @POST
    @Path(value="new/{handlerName}")
    public Response createNewBatch(@PathParam(value="handlerName") String handlerName) throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        Batch batch = bm.initBatch(handlerName);
        return this.getBatchExtraInfo(batch.getKey());
    }

    @POST
    public Response initBatch() throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        String batchId = bm.initBatch();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(REQUEST_BATCH_ID, batchId);
        return this.buildResponse((Response.StatusType)Response.Status.CREATED, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{batchId}/{fileIdx}")
    public Response upload(@Context HttpServletRequest request, @PathParam(value="batchId") String batchId, @PathParam(value="fileIdx") String fileIdx) throws IOException {
        TransactionHelper.commitOrRollbackTransaction();
        try {
            Response response = this.uploadNoTransaction(request, batchId, fileIdx);
            return response;
        }
        finally {
            TransactionHelper.startTransaction();
        }
    }

    protected Response uploadNoTransaction(@Context HttpServletRequest request, @PathParam(value="batchId") String batchId, @PathParam(value="fileIdx") String fileIdx) throws IOException {
        BatchFileEntry fileEntry;
        Blob blob;
        boolean isMultipart;
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        if (!bm.hasBatch(batchId)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        if (!NumberUtils.isDigits((String)fileIdx)) {
            return this.buildTextResponse((Response.StatusType)Response.Status.BAD_REQUEST, "fileIdx request path parameter must be a number");
        }
        String contentType = request.getHeader("Content-Type");
        String uploadType = request.getHeader("X-Upload-Type");
        if (!UPLOAD_TYPE_CHUNKED.equals(uploadType)) {
            uploadType = UPLOAD_TYPE_NORMAL;
        }
        String uploadChunkIndexHeader = request.getHeader("X-Upload-Chunk-Index");
        String chunkCountHeader = request.getHeader("X-Upload-Chunk-Count");
        String fileName = request.getHeader("X-File-Name");
        String fileSizeHeader = request.getHeader("X-File-Size");
        String mimeType = request.getHeader("X-File-Type");
        String requestBodyFile = request.getHeader("X-Request-Body-File");
        String contentMd5 = request.getHeader("X-Content-MD5");
        int chunkCount = -1;
        int uploadChunkIndex = -1;
        long fileSize = -1L;
        if (UPLOAD_TYPE_CHUNKED.equals(uploadType)) {
            try {
                chunkCount = Integer.parseInt(chunkCountHeader);
                uploadChunkIndex = Integer.parseInt(uploadChunkIndexHeader);
                fileSize = Long.parseLong(fileSizeHeader);
            }
            catch (NumberFormatException e) {
                throw new IllegalParameterException("X-Upload-Chunk-Index, X-Upload-Chunk-Count and X-File-Size headers must be numbers");
            }
        }
        long uploadedSize = this.getUploadedSize(request);
        boolean bl = isMultipart = contentType != null && contentType.contains("multipart");
        if (isMultipart) {
            FormData formData = new FormData(request);
            blob = formData.getFirstBlob();
            if (blob == null) {
                throw new NuxeoException("Cannot upload in multipart with no blobs");
            }
            if (!UPLOAD_TYPE_CHUNKED.equals(uploadType)) {
                fileName = blob.getFilename();
            }
            if (StringUtils.isBlank((CharSequence)mimeType)) {
                mimeType = blob.getMimeType();
            }
            uploadedSize = blob.getLength();
            this.addBlob(uploadType, batchId, fileIdx, blob, fileName, mimeType, uploadedSize, chunkCount, uploadChunkIndex, fileSize);
        } else if (Framework.isBooleanPropertyTrue((String)"nuxeo.nginx.accel.enabled") && StringUtils.isNotEmpty((CharSequence)requestBodyFile)) {
            if (StringUtils.isNotEmpty((CharSequence)fileName)) {
                fileName = URLDecoder.decode(fileName, "UTF-8");
            }
            File file = new File(requestBodyFile);
            blob = new FileBlob(file, true);
            if (StringUtils.isNotEmpty((CharSequence)contentMd5)) {
                blob.setDigest(contentMd5);
            }
            uploadedSize = file.length();
            this.addBlob(uploadType, batchId, fileIdx, blob, fileName, mimeType, uploadedSize, chunkCount, uploadChunkIndex, fileSize);
        } else {
            if (StringUtils.isNotEmpty((CharSequence)fileName)) {
                fileName = URLDecoder.decode(fileName, "UTF-8");
            }
            try (ServletInputStream is = request.getInputStream();){
                blob = Blobs.createBlob((InputStream)is);
                this.addBlob(uploadType, batchId, fileIdx, blob, fileName, mimeType, uploadedSize, chunkCount, uploadChunkIndex, fileSize);
            }
        }
        Object status = Response.Status.CREATED;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("uploaded", "true");
        result.put(REQUEST_BATCH_ID, batchId);
        result.put(REQUEST_FILE_IDX, fileIdx);
        result.put("uploadType", uploadType);
        result.put("uploadedSize", String.valueOf(uploadedSize));
        if (UPLOAD_TYPE_CHUNKED.equals(uploadType) && (fileEntry = bm.getFileEntry(batchId, fileIdx)) != null) {
            result.put("uploadedChunkIds", fileEntry.getOrderedChunkIndexes());
            result.put("chunkCount", fileEntry.getChunkCount());
            if (!fileEntry.isChunksCompleted()) {
                status = new ResumeIncompleteStatusType();
            }
        }
        return this.buildResponse((Response.StatusType)status, result, isMultipart);
    }

    protected long getUploadedSize(HttpServletRequest request) {
        String contentLength = request.getHeader("Content-Length");
        if (contentLength == null) {
            return -1L;
        }
        return Long.parseLong(contentLength);
    }

    protected void addBlob(String uploadType, String batchId, String fileIdx, Blob blob, String fileName, String mimeType, long uploadedSize, int chunkCount, int uploadChunkIndex, long fileSize) {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        Object uploadedSizeDisplay = uploadedSize > -1L ? uploadedSize + "b" : "unknown size";
        Batch batch = bm.getBatch(batchId);
        if (UPLOAD_TYPE_CHUNKED.equals(uploadType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Uploading chunk [index=%d / total=%d] (%s) for file %s", uploadChunkIndex, chunkCount, uploadedSizeDisplay, fileName));
            }
            batch.addChunk(fileIdx, blob, chunkCount, uploadChunkIndex, fileName, mimeType, fileSize);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Uploading file %s (%s)", fileName, uploadedSizeDisplay));
            }
            batch.addFile(fileIdx, blob, fileName, mimeType);
        }
    }

    @GET
    @Path(value="{batchId}")
    public Response getBatchInfo(@PathParam(value="batchId") String batchId) throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        if (!bm.hasBatch(batchId)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        List fileEntries = bm.getFileEntries(batchId);
        if (CollectionUtils.isEmpty((Collection)fileEntries)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NO_CONTENT);
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (BatchFileEntry fileEntry : fileEntries) {
            result.add(this.getFileInfo(fileEntry));
        }
        return this.buildResponse((Response.StatusType)Response.Status.OK, result);
    }

    @GET
    @Path(value="{batchId}/{fileIdx}")
    public Response getFileInfo(@PathParam(value="batchId") String batchId, @PathParam(value="fileIdx") String fileIdx) throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        if (!bm.hasBatch(batchId)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        BatchFileEntry fileEntry = bm.getFileEntry(batchId, fileIdx);
        if (fileEntry == null) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        Object status = Response.Status.OK;
        if (fileEntry.isChunked() && !fileEntry.isChunksCompleted()) {
            status = new ResumeIncompleteStatusType();
        }
        Map<String, Object> result = this.getFileInfo(fileEntry);
        return this.buildResponse((Response.StatusType)status, result);
    }

    @DELETE
    @Path(value="{batchId}")
    public Response cancel(@PathParam(value="batchId") String batchId) {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        if (!bm.hasBatch(batchId)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        bm.clean(batchId);
        return this.buildEmptyResponse((Response.StatusType)Response.Status.NO_CONTENT);
    }

    @DELETE
    @Path(value="{batchId}/{fileIdx}")
    public Response removeFile(@PathParam(value="batchId") String batchId, @PathParam(value="fileIdx") String fileIdx) {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        if (!bm.removeFileEntry(batchId, fileIdx)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        return this.buildEmptyResponse((Response.StatusType)Response.Status.NO_CONTENT);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{batchId}/execute/{operationId}")
    public Object execute(@PathParam(value="batchId") String batchId, @PathParam(value="operationId") String operationId, ExecutionRequest xreq) {
        return this.executeBatch(batchId, null, operationId, this.request, xreq);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{batchId}/{fileIdx}/execute/{operationId}")
    public Object execute(@PathParam(value="batchId") String batchId, @PathParam(value="fileIdx") String fileIdx, @PathParam(value="operationId") String operationId, ExecutionRequest xreq) {
        return this.executeBatch(batchId, fileIdx, operationId, this.request, xreq);
    }

    @GET
    @Path(value="{batchId}/info")
    public Response getBatchExtraInfo(@PathParam(value="batchId") String batchId) throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        if (!bm.hasBatch(batchId)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        Batch batch = bm.getBatch(batchId);
        Map properties = batch.getProperties();
        List fileEntries = batch.getFileEntries();
        ArrayList fileInfos = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)fileEntries)) {
            fileEntries.stream().map(this::getFileInfo).forEach(fileInfos::add);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("provider", batch.getHandlerName());
        if (properties != null && !properties.isEmpty()) {
            result.put("extraInfo", properties);
        }
        result.put("fileEntries", fileInfos);
        result.put(REQUEST_BATCH_ID, batch.getKey());
        return this.buildResponse((Response.StatusType)Response.Status.OK, result);
    }

    @POST
    @Path(value="{batchId}/refreshToken")
    public Response refreshToken(@PathParam(value="batchId") String batchId) throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        Batch batch = bm.getBatch(batchId);
        if (batch == null) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        BatchHandler handler = bm.getHandler(batch.getHandlerName());
        try {
            Map result = handler.refreshToken(batchId);
            result.put(REQUEST_BATCH_ID, batchId);
            return this.buildResponse((Response.StatusType)Response.Status.OK, result);
        }
        catch (UnsupportedOperationException e) {
            return Response.status((int)501).build();
        }
    }

    @POST
    @Path(value="{batchId}/{fileIdx}/complete")
    public Response uploadCompleted(@PathParam(value="batchId") String batchId, @PathParam(value="fileIdx") String fileIdx, String body) throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        JsonNode jsonNode = new ObjectMapper().readTree(body);
        Batch batch = bm.getBatch(batchId);
        if (batch == null) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        String key = jsonNode.hasNonNull(KEY) ? jsonNode.get(KEY).asText(null) : null;
        String filename = jsonNode.hasNonNull(NAME) ? jsonNode.get(NAME).asText() : null;
        String mimeType = jsonNode.hasNonNull(MIMETYPE) ? jsonNode.get(MIMETYPE).asText(null) : null;
        Long length = jsonNode.hasNonNull(FILE_SIZE) ? jsonNode.get(FILE_SIZE).asLong() : -1L;
        String md5 = jsonNode.hasNonNull(MD5) ? jsonNode.get(MD5).asText() : null;
        BatchFileInfo batchFileInfo = new BatchFileInfo(key, filename, mimeType, length.longValue(), md5);
        BatchHandler handler = bm.getHandler(batch.getHandlerName());
        if (!handler.completeUpload(batchId, fileIdx, batchFileInfo)) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("uploaded", "true");
        result.put(REQUEST_BATCH_ID, batchId);
        result.put(REQUEST_FILE_IDX, fileIdx);
        return this.buildResponse((Response.StatusType)Response.Status.OK, result);
    }

    protected Object executeBatch(String batchId, String fileIdx, String operationId, HttpServletRequest request, ExecutionRequest xreq) {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        if (!bm.hasBatch(batchId)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        if (!Boolean.parseBoolean(RequestContext.getActiveContext((ServletRequest)request).getRequest().getHeader("X-Batch-No-Drop"))) {
            RequestContext.getActiveContext((ServletRequest)request).addRequestCleanupHandler(req -> bm.clean(batchId));
        }
        try {
            CoreSession session = this.ctx.getCoreSession();
            OperationContext ctx = xreq.createContext(request, this.response, session);
            Map params = xreq.getParams();
            Object result = StringUtils.isBlank((CharSequence)fileIdx) ? bm.execute(batchId, operationId, session, (Map)ctx, params) : bm.execute(batchId, fileIdx, operationId, session, (Map)ctx, params);
            return ResponseHelper.getResponse((Object)result, (HttpServletRequest)request);
        }
        catch (IOException | MessagingException e) {
            log.error((Object)"Error while executing automation batch ", e);
            throw new NuxeoException(e);
        }
    }

    protected Response buildResponse(Response.StatusType status, Object object) throws IOException {
        return this.buildResponse(status, object, false);
    }

    protected Response buildResponse(Response.StatusType status, Object object, boolean html) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String result = mapper.writeValueAsString(object);
        if (html) {
            return this.buildHTMLResponse(status, result);
        }
        return this.buildJSONResponse(status, result);
    }

    protected Response buildJSONResponse(Response.StatusType status, String message) throws UnsupportedEncodingException {
        return this.buildResponse(status, "application/json", message);
    }

    protected Response buildHTMLResponse(Response.StatusType status, String message) throws UnsupportedEncodingException {
        message = "<html>" + (String)message + "</html>";
        return this.buildResponse(status, "text/html", (String)message);
    }

    protected Response buildTextResponse(Response.StatusType status, String message) throws UnsupportedEncodingException {
        return this.buildResponse(status, "text/plain", message);
    }

    protected Response buildEmptyResponse(Response.StatusType status) {
        return Response.status((Response.StatusType)status).build();
    }

    protected Response buildResponse(Response.StatusType status, String type, String message) throws UnsupportedEncodingException {
        return Response.status((Response.StatusType)status).header("Content-Length", (Object)message.getBytes("UTF-8").length).type(type + "; charset=UTF-8").entity((Object)message).build();
    }

    protected Map<String, Object> getFileInfo(BatchFileEntry fileEntry) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        boolean chunked = fileEntry.isChunked();
        String uploadType = chunked ? UPLOAD_TYPE_CHUNKED : UPLOAD_TYPE_NORMAL;
        info.put(NAME, fileEntry.getFileName());
        info.put("size", fileEntry.getFileSize());
        info.put("uploadType", uploadType);
        if (chunked) {
            info.put("uploadedChunkIds", fileEntry.getOrderedChunkIndexes());
            info.put("chunkCount", fileEntry.getChunkCount());
        }
        return info;
    }

    public final class ResumeIncompleteStatusType
    implements Response.StatusType {
        public int getStatusCode() {
            return 308;
        }

        public String getReasonPhrase() {
            return "Resume Incomplete";
        }

        public Response.Status.Family getFamily() {
            return Response.Status.Family.REDIRECTION;
        }
    }
}

