/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.directory;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.restapi.server.jaxrs.PaginableObject;
import org.nuxeo.ecm.restapi.server.jaxrs.directory.DirectorySessionRunner;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="directoryObject")
@Produces(value={"application/json"})
public class DirectoryObject
extends PaginableObject<DirectoryEntry> {
    public static final String PAGE_PROVIDER_NAME = "nuxeo_directory_entry_listing";
    private Directory directory;

    @Override
    protected void initialize(Object ... args) {
        super.initialize(args);
        if (args.length < 1) {
            throw new IllegalArgumentException("Directory Object takes one parameter");
        }
        String dirName = (String)args[0];
        this.directory = ((DirectoryService)Framework.getService(DirectoryService.class)).getDirectory(dirName);
        if (this.directory == null) {
            throw new WebResourceNotFoundException("Directory " + dirName + " was not found");
        }
    }

    @Override
    protected PageProviderDefinition getPageProviderDefinition() {
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        return pageProviderService.getPageProviderDefinition(PAGE_PROVIDER_NAME);
    }

    @Override
    protected Object[] getParams() {
        return new Object[]{this.directory};
    }

    @GET
    public List<DirectoryEntry> getDirectoryEntries() {
        return this.getPaginableEntries();
    }

    @POST
    public Response addEntry(final DirectoryEntry entry) {
        this.checkEditGuards();
        DirectoryEntry result = DirectorySessionRunner.withDirectorySession(this.directory, new DirectorySessionRunner<DirectoryEntry>(){

            @Override
            DirectoryEntry run(Session session) {
                DocumentModel docEntry = session.createEntry(entry.getDocumentModel());
                return new DirectoryEntry(DirectoryObject.this.directory.getName(), docEntry);
            }
        });
        return Response.ok((Object)result).status(Response.Status.CREATED).build();
    }

    void checkEditGuards() {
        NuxeoPrincipal currentUser = this.getContext().getCoreSession().getPrincipal();
        if (!currentUser.isAdministrator() && !currentUser.isMemberOf("powerusers")) {
            throw new WebSecurityException("Not allowed to edit directory");
        }
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        if (this.directory.getName().equals(um.getUserDirectoryName()) || this.directory.getName().equals(um.getGroupDirectoryName())) {
            throw new NuxeoException("Not allowed to edit user/group directories, please use user/group endpoints", 400);
        }
    }

    @Path(value="{entryId:((?:(?!/@).)*)}")
    public Object getEntry(final @PathParam(value="entryId") String entryId) {
        return DirectorySessionRunner.withDirectorySession(this.directory, new DirectorySessionRunner<Object>(){

            @Override
            Object run(Session session) {
                DocumentModel entry = session.getEntry(entryId);
                if (entry == null) {
                    throw new WebResourceNotFoundException("Entry not found");
                }
                return DirectoryObject.this.newObject("directoryEntry", new Object[]{new DirectoryEntry(DirectoryObject.this.directory.getName(), entry), entryId});
            }
        });
    }
}

