/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.jaxrs.xml.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.java.dev.webdav.jaxrs.ConstantsAdapter;
import net.java.dev.webdav.util.Utilities;

@XmlJavaTypeAdapter(value=Adapter.class)
@XmlRootElement(name="resourcetype")
public final class ResourceType {
    public static final ResourceType RESOURCETYPE = new ResourceType();
    @XmlAnyElement(lax=true)
    private final List<Object> resourceTypes;
    public static final ResourceType COLLECTION = new ResourceType(net.java.dev.webdav.jaxrs.xml.elements.Collection.COLLECTION);

    @Deprecated
    public ResourceType() {
        this.resourceTypes = new LinkedList<Object>();
    }

    public ResourceType(Object ... resourceTypes) {
        this.resourceTypes = Arrays.asList(Utilities.notNull(resourceTypes, "resourceTypes"));
    }

    @Deprecated
    public final List<Object> getResourceType() {
        return this.getResourceTypes();
    }

    public final List<Object> getResourceTypes() {
        return Collections.unmodifiableList(this.resourceTypes);
    }

    public final int hashCode() {
        return this.resourceTypes.hashCode();
    }

    public final boolean equals(Object other) {
        if (!(other instanceof ResourceType)) {
            return false;
        }
        ResourceType that = (ResourceType)other;
        return this.resourceTypes.equals(that.resourceTypes);
    }

    public final String toString() {
        return Utilities.toString(this, this.resourceTypes);
    }

    protected static final class Adapter
    extends ConstantsAdapter<ResourceType> {
        protected Adapter() {
        }

        @Override
        protected final Collection<ResourceType> getConstants() {
            return Arrays.asList(RESOURCETYPE, COLLECTION);
        }
    }
}

