/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.api;

import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;

public abstract class AbstractBasePublicationTree
implements PublicationTree {
    private static final long serialVersionUID = 1L;
    public static final String ROOT_PATH_KEY = "RootPath";
    public static final String ICON_EXPANDED_KEY = "iconExpanded";
    public static final String ICON_COLLAPSED_KEY = "iconCollapsed";
    public static final String TITLE_KEY = "title";
    protected PublicationNode rootNode;
    protected PublishedDocumentFactory factory;
    protected CoreSession coreSession;
    protected String configName;
    protected String rootPath;
    protected String treeTitle;
    protected String iconCollapsed = "/icons/folder.gif";
    protected String iconExpanded = "/icons/folder_open.gif";

    protected abstract String getDefaultRootPath();

    protected abstract PublishedDocumentFactory getDefaultFactory();

    @Override
    public void initTree(CoreSession coreSession, Map<String, String> parameters, PublishedDocumentFactory factory, String configName, String title) {
        this.coreSession = coreSession;
        if (factory != null) {
            this.factory = factory;
        } else {
            this.factory = this.getDefaultFactory();
            this.factory.init(coreSession, parameters);
        }
        this.rootPath = parameters.containsKey(ROOT_PATH_KEY) ? parameters.get(ROOT_PATH_KEY) : this.getDefaultRootPath();
        if (parameters.containsKey(ICON_COLLAPSED_KEY)) {
            this.iconCollapsed = parameters.get(ICON_COLLAPSED_KEY);
        }
        if (parameters.containsKey(ICON_EXPANDED_KEY)) {
            this.iconExpanded = parameters.get(ICON_EXPANDED_KEY);
        }
        this.treeTitle = title != null ? title : configName;
        this.configName = configName;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getNodeType() {
        return this.rootNode.getNodeType();
    }

    @Override
    public String getType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getTreeType() {
        return this.getType();
    }

    @Override
    public String getTreeTitle() {
        return this.treeTitle;
    }

    @Override
    public List<PublishedDocument> getPublishedDocumentInNode(PublicationNode node) {
        return node.getChildrenDocuments();
    }

    @Override
    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode) {
        return this.factory.publishDocument(doc, targetNode);
    }

    @Override
    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) {
        return this.factory.publishDocument(doc, targetNode, params);
    }

    @Override
    public String getTitle() {
        return this.rootNode.getTitle();
    }

    @Override
    public String getName() {
        return this.rootNode.getName();
    }

    @Override
    public PublicationTree getTree() {
        return this;
    }

    @Override
    public PublicationNode getParent() {
        return null;
    }

    @Override
    public List<PublicationNode> getChildrenNodes() {
        return this.rootNode.getChildrenNodes();
    }

    @Override
    public List<PublishedDocument> getChildrenDocuments() {
        return this.rootNode.getChildrenDocuments();
    }

    @Override
    public String getPath() {
        return this.rootNode.getPath();
    }

    @Override
    public void setCurrentDocument(DocumentModel currentDocument) {
    }

    @Override
    public String getIconExpanded() {
        return this.iconExpanded;
    }

    @Override
    public String getIconCollapsed() {
        return this.iconCollapsed;
    }

    @Override
    public void validatorPublishDocument(PublishedDocument publishedDocument, String comment) {
        if (!this.accept(publishedDocument)) {
            return;
        }
        this.factory.validatorPublishDocument(publishedDocument, comment);
    }

    @Override
    public void validatorRejectPublication(PublishedDocument publishedDocument, String comment) {
        if (!this.accept(publishedDocument)) {
            return;
        }
        this.factory.validatorRejectPublication(publishedDocument, comment);
    }

    @Override
    public boolean canPublishTo(PublicationNode publicationNode) {
        return publicationNode != null && publicationNode.getParent() != null;
    }

    @Override
    public boolean canUnpublish(PublishedDocument publishedDocument) {
        return this.accept(publishedDocument);
    }

    @Override
    public boolean hasValidationTask(PublishedDocument publishedDocument) {
        if (!this.accept(publishedDocument)) {
            return false;
        }
        return this.factory.hasValidationTask(publishedDocument);
    }

    @Override
    public boolean canManagePublishing(PublishedDocument publishedDocument) {
        if (!this.accept(publishedDocument)) {
            return false;
        }
        return this.factory.canManagePublishing(publishedDocument);
    }

    @Override
    public PublishedDocument wrapToPublishedDocument(DocumentModel documentModel) {
        return this.factory.wrapDocumentModel(documentModel);
    }

    @Override
    public boolean isPublicationNode(DocumentModel documentModel) {
        return false;
    }

    @Override
    public PublicationNode wrapToPublicationNode(DocumentModel documentModel) {
        throw new UnsupportedOperationException("");
    }

    protected abstract boolean accept(PublishedDocument var1);
}

