/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.factory;

import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.jmx.ConfigConstants;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.util.ObjectFactory;

public class PropertyWroConfigurationFactory
implements ObjectFactory<WroConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyWroConfigurationFactory.class);
    private final Properties properties;

    public PropertyWroConfigurationFactory() {
        this(new Properties());
    }

    public PropertyWroConfigurationFactory(Properties props) {
        Validate.notNull((Object)props);
        this.properties = props;
    }

    @Override
    public WroConfiguration create() {
        WroConfiguration config = new WroConfiguration();
        config.setDebug(this.valueAsBoolean(this.properties.get(ConfigConstants.debug.name()), true));
        config.setGzipEnabled(this.valueAsBoolean(this.properties.get(ConfigConstants.gzipResources.name()), true));
        config.setJmxEnabled(this.valueAsBoolean(this.properties.get(ConfigConstants.jmxEnabled.name()), true));
        config.setCacheUpdatePeriod(this.valueAsLong(this.properties.get(ConfigConstants.cacheUpdatePeriod.name()), 0L));
        config.setModelUpdatePeriod(this.valueAsLong(this.properties.get(ConfigConstants.modelUpdatePeriod.name()), 0L));
        config.setResourceWatcherUpdatePeriod(this.valueAsLong(this.properties.get(ConfigConstants.resourceWatcherUpdatePeriod.name()), 0L));
        config.setResourceWatcherAsync(this.valueAsBoolean(this.properties.get(ConfigConstants.resourceWatcherAsync.name()), false));
        config.setMinimizeEnabled(this.valueAsBoolean(this.properties.get(ConfigConstants.minimizeEnabled.name()), true));
        config.setIgnoreMissingResources(this.valueAsBoolean(this.properties.get(ConfigConstants.ignoreMissingResources.name()), true));
        config.setIgnoreEmptyGroup(this.valueAsBoolean(this.properties.get(ConfigConstants.ignoreEmptyGroup.name()), true));
        config.setIgnoreFailingProcessor(this.valueAsBoolean(this.properties.get(ConfigConstants.ignoreFailingProcessor.name()), false));
        config.setEncoding(this.valueAsString(this.properties.get(ConfigConstants.encoding.name()), "UTF-8"));
        config.setWroManagerClassName(this.valueAsString(this.properties.get(ConfigConstants.managerFactoryClassName.name())));
        config.setMbeanName(this.valueAsString(this.properties.get(ConfigConstants.mbeanName.name())));
        config.setHeader(this.valueAsString(this.properties.get(ConfigConstants.header.name())));
        config.setCacheGzippedContent(this.valueAsBoolean(this.properties.get(ConfigConstants.cacheGzippedContent.name()), false));
        config.setParallelPreprocessing(this.valueAsBoolean(this.properties.get(ConfigConstants.parallelPreprocessing.name()), false));
        config.setConnectionTimeout((int)this.valueAsLong(this.properties.get(ConfigConstants.connectionTimeout.name()), 2000L));
        LOG.debug("WroConfiguration created: {}", (Object)config);
        return config;
    }

    private long valueAsLong(Object object, long defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(this.valueAsString(object));
        }
        catch (NumberFormatException e) {
            String message = "Invalid long value: " + object + ". Using defaultValue: " + defaultValue;
            LOG.error(message);
            throw new WroRuntimeException(message);
        }
    }

    private boolean valueAsBoolean(Object object, boolean defaultValue) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)this.valueAsString(object)), (boolean)defaultValue);
    }

    private String valueAsString(Object object) {
        return this.valueAsString(object, null);
    }

    private String valueAsString(Object object, String defaultValue) {
        return object != null ? String.valueOf(object) : defaultValue;
    }
}

