/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.session.SessionInfo;
import org.nuxeo.runtime.management.counters.CounterHelper;

public class NuxeoHttpSessionMonitor {
    public static final String REQUEST_COUNTER = "org.nuxeo.web.requests";
    public static final String SESSION_COUNTER = "org.nuxeo.web.sessions";
    public static final long REQUEST_COUNTER_STEP = 5L;
    protected static final Log log = LogFactory.getLog(NuxeoHttpSessionMonitor.class);
    protected static NuxeoHttpSessionMonitor instance = new NuxeoHttpSessionMonitor();
    protected long globalRequestCounter;
    protected Map<String, SessionInfo> sessionTracker = new ConcurrentHashMap<String, SessionInfo>();

    public static NuxeoHttpSessionMonitor instance() {
        return instance;
    }

    protected void increaseRequestCounter() {
        ++this.globalRequestCounter;
        if (this.globalRequestCounter == 1L || this.globalRequestCounter % 5L == 0L) {
            CounterHelper.setCounterValue((String)REQUEST_COUNTER, (long)this.globalRequestCounter);
        }
    }

    public SessionInfo addEntry(HttpSession session) {
        if (session == null || session.getId() == null) {
            return null;
        }
        SessionInfo si = new SessionInfo(session.getId());
        this.sessionTracker.put(session.getId(), si);
        return si;
    }

    public SessionInfo associatedUser(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null && session.getId() != null) {
            SessionInfo si = this.sessionTracker.get(session.getId());
            if (si == null) {
                si = this.addEntry(session);
            }
            if (request.getUserPrincipal() != null && si.getLoginName() == null) {
                si.setLoginName(request.getUserPrincipal().getName());
                CounterHelper.increaseCounter((String)SESSION_COUNTER);
            }
            si.setLastAccessUrl(request.getRequestURI());
            this.increaseRequestCounter();
            return si;
        }
        return null;
    }

    public SessionInfo associatedUser(HttpSession session, String userName) {
        if (session == null || session.getId() == null) {
            return null;
        }
        SessionInfo si = this.sessionTracker.get(session.getId());
        if (si == null) {
            si = this.addEntry(session);
        }
        if (si.getLoginName() == null) {
            si.setLoginName(userName);
            CounterHelper.increaseCounter((String)SESSION_COUNTER);
        }
        return si;
    }

    public SessionInfo updateEntry(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null && session.getId() != null) {
            SessionInfo si = this.sessionTracker.get(session.getId());
            if (si != null) {
                si.updateLastAccessTime();
                si.setLastAccessUrl(request.getRequestURI());
                this.increaseRequestCounter();
                return si;
            }
            return this.addEntry(session);
        }
        return null;
    }

    public void removeEntry(String sid) {
        SessionInfo si = this.sessionTracker.remove(sid);
        if (si != null && si.getLoginName() != null) {
            CounterHelper.decreaseCounter((String)SESSION_COUNTER);
        }
    }

    public Collection<SessionInfo> getTrackedSessions() {
        return this.sessionTracker.values();
    }

    public List<SessionInfo> getSortedSessions() {
        ArrayList<SessionInfo> sortedSessions = new ArrayList<SessionInfo>();
        for (SessionInfo si : this.getTrackedSessions()) {
            if (si.getLoginName() == null) continue;
            sortedSessions.add(si);
        }
        Collections.sort(sortedSessions);
        return sortedSessions;
    }

    public List<SessionInfo> getSortedSessions(long maxInactivity) {
        ArrayList<SessionInfo> sortedSessions = new ArrayList<SessionInfo>();
        for (SessionInfo si : this.getTrackedSessions()) {
            if (si.getLoginName() == null || si.getInactivityInS() >= maxInactivity) continue;
            sortedSessions.add(si);
        }
        Collections.sort(sortedSessions);
        return sortedSessions;
    }

    public long getGlobalRequestCounter() {
        return this.globalRequestCounter;
    }
}

