/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore.computation;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.work.BaseOverflowRecordFilter;
import org.nuxeo.runtime.api.Framework;

public class TransientStoreOverflowRecordFilter
extends BaseOverflowRecordFilter {
    private static final Logger log = LogManager.getLogger(TransientStoreOverflowRecordFilter.class);

    public void init(Map<String, String> options) {
        super.init(options);
        this.getTransientStore();
    }

    protected TransientStore getTransientStore() {
        return ((TransientStoreService)Framework.getService(TransientStoreService.class)).getStore(this.getStoreName());
    }

    protected void storeValue(String recordKey, byte[] data) {
        String key = this.getPrefixedKey(recordKey);
        ByteArrayBlob blob = new ByteArrayBlob(data);
        TransientStore store = this.getTransientStore();
        store.putBlobs(key, Collections.singletonList(blob));
        store.setCompleted(key, true);
    }

    protected byte[] fetchValue(String recordKey) {
        Blob blob;
        String key = this.getPrefixedKey(recordKey);
        List<Blob> blobs = this.getTransientStore().getBlobs(key);
        Blob blob2 = blob = blobs == null || blobs.isEmpty() ? null : blobs.get(0);
        if (blob == null) {
            log.error("Blob value not found for record: {}", (Object)recordKey);
            return null;
        }
        try {
            return blob.getByteArray();
        }
        catch (IOException e) {
            log.error("Cannot get bytes of blob value for record: {}", (Object)recordKey, (Object)e);
            return null;
        }
    }
}

