/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.trash;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.trash.TrashService;
import org.nuxeo.ecm.core.trash.AbstractTrashService;

@Deprecated
public class LifeCycleTrashService
extends AbstractTrashService {
    private static final Log log = LogFactory.getLog(LifeCycleTrashService.class);
    public static final String FROM_LIFE_CYCLE_TRASH_SERVICE = "fromLifeCycleTrashService";

    public boolean isTrashed(CoreSession session, DocumentRef docRef) {
        return "deleted".equals(session.getCurrentLifeCycleState(docRef));
    }

    public void trashDocuments(List<DocumentModel> docs) {
        if (docs.isEmpty()) {
            return;
        }
        CoreSession session = docs.get(0).getCoreSession();
        for (DocumentModel doc : docs) {
            DocumentRef docRef = doc.getRef();
            if (session.getAllowedStateTransitions(docRef).contains("delete") && !doc.isProxy()) {
                if (!session.canRemoveDocument(docRef)) {
                    throw new DocumentSecurityException("User " + session.getPrincipal().getName() + " does not have the permission to remove the document " + doc.getId() + " (" + doc.getPath() + ")");
                }
                this.trashDocument(session, doc);
                continue;
            }
            if (session.isTrashed(docRef)) {
                log.warn((Object)("Document " + doc.getId() + " of type " + doc.getType() + " is already in the trash, nothing to do"));
                return;
            }
            log.warn((Object)("Document " + doc.getId() + " of type " + doc.getType() + " in state " + doc.getCurrentLifeCycleState() + " does not support transition delete, it will be deleted immediately"));
            session.removeDocument(docRef);
        }
        session.save();
    }

    protected void trashDocument(CoreSession session, DocumentModel doc) {
        if (doc.getParentRef() == null) {
            session.removeDocument(doc.getRef());
        } else {
            if (!Boolean.TRUE.equals(doc.getContextData("skipTrashRenaming"))) {
                String name = this.mangleName(doc);
                session.move(doc.getRef(), doc.getParentRef(), name);
            }
            doc.putContextData(FROM_LIFE_CYCLE_TRASH_SERVICE, (Serializable)Boolean.TRUE);
            session.followTransition(doc, "delete");
        }
    }

    @Override
    public Set<DocumentRef> undeleteDocuments(List<DocumentModel> docs) {
        HashSet<DocumentRef> undeleted = new HashSet<DocumentRef>();
        if (docs.isEmpty()) {
            return undeleted;
        }
        CoreSession session = docs.get(0).getCoreSession();
        Set<DocumentRef> docRefs = this.undeleteDocumentList(session, docs);
        undeleted.addAll(docRefs);
        for (DocumentRef docRef : docRefs) {
            this.undeleteAncestors(session, docRef, undeleted);
        }
        session.save();
        HashSet<DocumentRef> parentRefs = new HashSet<DocumentRef>();
        for (DocumentRef docRef : undeleted) {
            parentRefs.add(session.getParentDocumentRef(docRef));
        }
        for (DocumentModel doc : docs) {
            if (!doc.isFolder()) continue;
            this.notifyEvent(session, "documentUndeleted", doc, true);
        }
        return parentRefs;
    }

    protected Set<DocumentRef> undeleteDocumentList(CoreSession session, List<DocumentModel> docs) {
        HashSet<DocumentRef> undeleted = new HashSet<DocumentRef>();
        for (DocumentModel doc : docs) {
            DocumentRef docRef = doc.getRef();
            if (session.getAllowedStateTransitions(docRef).contains("undelete")) {
                this.undeleteDocument(session, doc);
                undeleted.add(docRef);
                continue;
            }
            log.debug((Object)("Impossible to undelete document " + docRef + " as it does not support transition undelete"));
        }
        return undeleted;
    }

    protected void undeleteAncestors(CoreSession session, DocumentRef docRef, Set<DocumentRef> undeleted) {
        for (DocumentRef ancestorRef : session.getParentDocumentRefs(docRef)) {
            if (session.hasPermission(ancestorRef, "ReadLifeCycle") && session.hasPermission(ancestorRef, "WriteLifeCycle")) {
                if (!session.getAllowedStateTransitions(ancestorRef).contains("undelete")) break;
            } else {
                log.debug((Object)("Stopping to restore ancestors because " + ancestorRef.toString() + " is not readable"));
                break;
            }
            DocumentModel ancestor = session.getDocument(ancestorRef);
            this.undeleteDocument(session, ancestor);
            undeleted.add(ancestorRef);
        }
    }

    protected void undeleteDocument(CoreSession session, DocumentModel doc) {
        String newName;
        String name = doc.getName();
        if (!Boolean.TRUE.equals(doc.getContextData("skipTrashRenaming")) && !(newName = this.unmangleName(doc)).equals(name)) {
            session.move(doc.getRef(), doc.getParentRef(), newName);
        }
        doc.putContextData(FROM_LIFE_CYCLE_TRASH_SERVICE, (Serializable)Boolean.TRUE);
        session.followTransition(doc, "undelete");
    }

    public boolean hasFeature(TrashService.Feature feature) {
        switch (feature) {
            case TRASHED_STATE_IS_DEDUCED_FROM_LIFECYCLE: {
                return true;
            }
            case TRASHED_STATE_IN_MIGRATION: 
            case TRASHED_STATE_IS_DEDICATED_PROPERTY: {
                return false;
            }
        }
        throw new UnsupportedOperationException(feature.name());
    }
}

