/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelComparator;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryCSVLoader;
import org.nuxeo.ecm.directory.DirectoryCache;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFieldMapper;
import org.nuxeo.ecm.directory.InverseReference;
import org.nuxeo.ecm.directory.InverseReferenceDescriptor;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.ReferenceDescriptor;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryDeleteConstraint;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class AbstractDirectory
implements Directory {
    private static final Logger log = LogManager.getLogger(AbstractDirectory.class);
    public static final String TENANT_ID_FIELD = "tenantId";
    public final BaseDirectoryDescriptor descriptor;
    protected DirectoryFieldMapper fieldMapper;
    protected final Map<String, List<Reference>> references = new HashMap<String, List<Reference>>();
    protected final DirectoryCache cache;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter sessionCount;
    protected final Counter sessionMaxCount;
    protected Map<String, Field> schemaFieldMap;
    protected List<String> types = new ArrayList<String>();
    protected Class<? extends Reference> referenceClass;

    protected AbstractDirectory(BaseDirectoryDescriptor descriptor, Class<? extends Reference> referenceClass) {
        this.referenceClass = referenceClass;
        this.descriptor = descriptor;
        if (descriptor.types != null) {
            this.types = Arrays.asList(descriptor.types);
        }
        if (!descriptor.template && this.doSanityChecks()) {
            if (StringUtils.isEmpty((CharSequence)descriptor.idField)) {
                throw new DirectoryException("idField configuration is missing for directory: " + this.getName());
            }
            if (StringUtils.isEmpty((CharSequence)descriptor.schemaName)) {
                throw new DirectoryException("schema configuration is missing for directory " + this.getName());
            }
        }
        this.sessionCount = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "directories", "directory", "sessions", "active"}).tagged(new String[]{"directory", this.getName()}));
        this.sessionMaxCount = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "directories", "directory", "sessions", "max"}).tagged(new String[]{"directory", this.getName()}));
        this.addReferences();
        this.addInverseReferences();
        this.cache = new DirectoryCache(this.getName());
        this.cache.setEntryCacheName(descriptor.cacheEntryName);
        this.cache.setEntryCacheWithoutReferencesName(descriptor.cacheEntryWithoutReferencesName);
        this.cache.setNegativeCaching(descriptor.negativeCaching);
    }

    protected boolean doSanityChecks() {
        return true;
    }

    public void initialize() {
        this.initSchemaFieldMap();
    }

    @Deprecated(since="11.1")
    protected void loadData() {
        this.loadDataOnInit(false);
    }

    protected void loadDataOnInit(boolean tableExists) {
        String dataFileName = this.descriptor.getDataFileName();
        if (StringUtils.isBlank((CharSequence)dataFileName)) {
            return;
        }
        String dataLoadingPolicy = this.descriptor.getDataLoadingPolicy();
        if (tableExists && ("legacy".equals(dataLoadingPolicy) || this.descriptor.isAutoincrementIdField())) {
            log.debug("Don't load directory: {} on init as table already exists", new Supplier[]{this::getName});
            return;
        }
        if ("never_load".equals(dataLoadingPolicy)) {
            log.debug("Don't load directory: {} on init due to never load policy", new Supplier[]{this::getName});
            return;
        }
        Blob blob = DirectoryCSVLoader.createBlob(dataFileName);
        log.info("Load directory: {} with dataLoadingPolicy: {} and file: {}", (Object)this.getName(), (Object)dataLoadingPolicy, (Object)dataFileName);
        TransactionHelper.runInTransaction(() -> Framework.doPrivileged(() -> this.loadFromCSV(blob, dataLoadingPolicy)));
    }

    public void loadFromCSV(Blob dataBlob, String dataLoadingPolicy) {
        if (dataBlob == null) {
            throw new DirectoryException("dataBlob must not be null", 400);
        }
        BaseDirectoryDescriptor.checkDataLoadingPolicy((String)dataLoadingPolicy);
        try (Session session = this.getSession();){
            String schemaName = this.getSchema();
            Schema schema = ((SchemaManager)Framework.getService(SchemaManager.class)).getSchema(schemaName);
            CSVLoaderConsumer loader = new CSVLoaderConsumer(dataLoadingPolicy, session, schemaName);
            DirectoryCSVLoader.loadData(dataBlob, this.descriptor.getDataFileCharacterSeparator(), schema, (Consumer<Map<String, Object>>)loader);
            this.invalidateCaches();
        }
    }

    public void initializeReferences() {
    }

    public void initializeInverseReferences() {
        for (Reference reference : this.getReferences()) {
            if (!(reference instanceof InverseReference)) continue;
            ((InverseReference)reference).initialize();
        }
    }

    public String getName() {
        return this.descriptor.name;
    }

    public String getSchema() {
        return this.descriptor.schemaName;
    }

    public String getParentDirectory() {
        return this.descriptor.parentDirectory;
    }

    public String getIdField() {
        return this.descriptor.idField;
    }

    public String getPasswordField() {
        return this.descriptor.passwordField;
    }

    public boolean isReadOnly() {
        return this.descriptor.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.descriptor.setReadOnly(readOnly);
    }

    public void invalidateCaches() {
        this.cache.invalidateAll();
        for (Reference ref : this.getReferences()) {
            Directory targetDir = ref.getTargetDirectory();
            if (targetDir == null) continue;
            targetDir.invalidateDirectoryCache();
        }
    }

    public DirectoryFieldMapper getFieldMapper() {
        if (this.fieldMapper == null) {
            this.fieldMapper = new DirectoryFieldMapper();
        }
        return this.fieldMapper;
    }

    @Deprecated
    public Reference getReference(String referenceFieldName) {
        List<Reference> refs = this.getReferences(referenceFieldName);
        if (refs == null || refs.isEmpty()) {
            return null;
        }
        if (refs.size() == 1) {
            return refs.get(0);
        }
        throw new DirectoryException("Unexpected multiple references for " + referenceFieldName + " in directory " + this.getName());
    }

    public List<Reference> getReferences(String referenceFieldName) {
        return this.references.get(referenceFieldName);
    }

    public boolean isReference(String referenceFieldName) {
        return this.references.containsKey(referenceFieldName);
    }

    public void addReference(Reference reference) {
        reference.setSourceDirectoryName(this.getName());
        String fieldName = reference.getFieldName();
        this.references.computeIfAbsent(fieldName, k -> new ArrayList(1)).add(reference);
    }

    protected void addReferences() {
        ReferenceDescriptor[] descs = this.descriptor.getReferences();
        if (descs != null) {
            Arrays.stream(descs).map(this::newReference).forEach(this::addReference);
        }
    }

    protected Reference newReference(ReferenceDescriptor desc) {
        try {
            return this.referenceClass.getDeclaredConstructor(ReferenceDescriptor.class).newInstance(desc);
        }
        catch (ReflectiveOperationException e) {
            throw new DirectoryException("An error occurred while instantiating reference class " + this.referenceClass.getName(), (Throwable)e);
        }
    }

    protected void addInverseReferences() {
        InverseReferenceDescriptor[] descs = this.descriptor.getInverseReferences();
        if (descs != null) {
            Arrays.stream(descs).map(InverseReference::new).forEach(this::addReference);
        }
    }

    public Collection<Reference> getReferences() {
        ArrayList<Reference> allRefs = new ArrayList<Reference>(2);
        for (List<Reference> refs : this.references.values()) {
            allRefs.addAll(refs);
        }
        return allRefs;
    }

    public void orderEntries(List<DocumentModel> entries, Map<String, String> orderBy) {
        entries.sort((Comparator<DocumentModel>)new DocumentModelComparator(this.getSchema(), orderBy));
    }

    public static Map<String, String> makeOrderBy(OrderByList orders) {
        HashMap<String, String> orderBy = new HashMap<String, String>();
        for (OrderByExpr ob : orders) {
            String ascOrDesc = ob.isDescending ? "desc" : "asc";
            orderBy.put(ob.reference.name, ascOrDesc);
        }
        return orderBy;
    }

    public DirectoryCache getCache() {
        return this.cache;
    }

    public void removeSession(Session session) {
        this.sessionCount.dec();
    }

    public void addSession(Session session) {
        this.sessionCount.inc();
        if (this.sessionCount.getCount() > this.sessionMaxCount.getCount()) {
            this.sessionMaxCount.inc();
        }
    }

    public void invalidateDirectoryCache() {
        this.getCache().invalidateAll();
    }

    public boolean isMultiTenant() {
        return false;
    }

    public void shutdown() {
        this.sessionCount.dec(this.sessionCount.getCount());
        this.sessionMaxCount.dec(this.sessionMaxCount.getCount());
    }

    public List<String> getTypes() {
        return this.types;
    }

    public List<DirectoryDeleteConstraint> getDirectoryDeleteConstraints() {
        return this.descriptor.getDeleteConstraints();
    }

    protected void initSchemaFieldMap() {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        Schema schema = schemaManager.getSchema(this.getSchema());
        if (schema == null) {
            throw new DirectoryException("Invalid configuration for directory: " + this.getName() + ", no such schema: " + this.getSchema());
        }
        this.schemaFieldMap = new LinkedHashMap<String, Field>();
        schema.getFields().forEach(f -> this.schemaFieldMap.put(f.getName().getLocalName(), (Field)f));
    }

    public Map<String, Field> getSchemaFieldMap() {
        return this.schemaFieldMap;
    }

    protected void fallbackOnDefaultCache() {
        CacheService cacheService = (CacheService)Framework.getService(CacheService.class);
        if (cacheService != null) {
            if (this.descriptor.cacheEntryName == null) {
                String cacheEntryName = "cache-" + this.getName();
                this.cache.setEntryCacheName(cacheEntryName);
                cacheService.registerCache(cacheEntryName);
            }
            if (this.descriptor.cacheEntryWithoutReferencesName == null) {
                String cacheEntryWithoutReferencesName = "cacheWithoutReference-" + this.getName();
                this.cache.setEntryCacheWithoutReferencesName(cacheEntryWithoutReferencesName);
                cacheService.registerCache(cacheEntryWithoutReferencesName);
            }
        }
    }

    protected static class CSVLoaderConsumer
    implements Consumer<Map<String, Object>> {
        protected final String dataLoadingPolicy;
        protected final Session session;
        protected final String schema;

        public CSVLoaderConsumer(String dataLoadingPolicy, Session session, String schema) {
            this.dataLoadingPolicy = dataLoadingPolicy;
            this.session = session;
            this.schema = schema;
        }

        @Override
        public void accept(Map<String, Object> fieldMap) {
            if ("reject_duplicate".equals(this.dataLoadingPolicy) || "legacy".equals(this.dataLoadingPolicy)) {
                ((BaseSession)this.session).createEntryWithoutReferences(fieldMap);
            } else {
                Object rawId = fieldMap.get(this.session.getIdField());
                if (rawId == null) {
                    throw new DirectoryException("A line is missing the entry id", 400);
                }
                String idValue = String.valueOf(rawId);
                if (this.session.hasEntry(idValue)) {
                    if ("update_duplicate".equals(this.dataLoadingPolicy)) {
                        DocumentModel dm = this.session.getEntry(idValue);
                        fieldMap.forEach((fieldName, value) -> dm.setProperty(this.schema, fieldName, value));
                        ((BaseSession)this.session).updateEntryWithoutReferences(dm);
                    } else {
                        log.debug("Skip the entry with id: {}", (Object)idValue);
                    }
                } else {
                    ((BaseSession)this.session).createEntryWithoutReferences(fieldMap);
                }
            }
        }
    }
}

