/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.weighted_avg;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.weighted_avg.WeightedAvg;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalWeightedAvg
extends InternalNumericMetricsAggregation.SingleValue
implements WeightedAvg {
    private final double sum;
    private final double weight;

    public InternalWeightedAvg(String name, double sum, double weight, DocValueFormat format, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.sum = sum;
        this.weight = weight;
        this.format = format;
    }

    public InternalWeightedAvg(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.sum = in.readDouble();
        this.weight = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDouble(this.sum);
        out.writeDouble(this.weight);
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public double getValue() {
        return this.sum / this.weight;
    }

    double getSum() {
        return this.sum;
    }

    double getWeight() {
        return this.weight;
    }

    DocValueFormat getFormatter() {
        return this.format;
    }

    @Override
    public String getWriteableName() {
        return "weighted_avg";
    }

    @Override
    public InternalWeightedAvg doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double weight = 0.0;
        double sum = 0.0;
        double sumCompensation = 0.0;
        double weightCompensation = 0.0;
        for (InternalAggregation aggregation : aggregations) {
            double corrected;
            InternalWeightedAvg avg = (InternalWeightedAvg)aggregation;
            if (!Double.isFinite(avg.weight)) {
                weight += avg.weight;
            } else if (Double.isFinite(weight)) {
                corrected = avg.weight - weightCompensation;
                double newWeight = weight + corrected;
                weightCompensation = newWeight - weight - corrected;
                weight = newWeight;
            }
            if (!Double.isFinite(avg.sum)) {
                sum += avg.sum;
                continue;
            }
            if (!Double.isFinite(sum)) continue;
            corrected = avg.sum - sumCompensation;
            double newSum = sum + corrected;
            sumCompensation = newSum - sum - corrected;
            sum = newSum;
        }
        return new InternalWeightedAvg(this.getName(), sum, weight, this.format, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.weight != 0.0 ? Double.valueOf(this.getValue()) : null);
        if (this.weight != 0.0 && this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.getValue()));
        }
        return builder;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.sum, this.weight, this.format.getWriteableName());
    }

    @Override
    protected boolean doEquals(Object obj) {
        InternalWeightedAvg other = (InternalWeightedAvg)obj;
        return Objects.equals(this.sum, other.sum) && Objects.equals(this.weight, other.weight) && Objects.equals(this.format.getWriteableName(), other.format.getWriteableName());
    }
}

