/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public abstract class Suggestion
implements Serializable {
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    private static final long serialVersionUID = 1L;
    protected final String id;
    protected final String type;
    protected final String label;
    protected final String iconURL;
    protected String thumbnailURL = "";
    protected String description = "";
    protected Map<String, List<String>> highlights;
    protected boolean disabled = false;

    public Suggestion(String id, String type, String label, String iconURL) {
        this.id = id;
        this.type = type;
        this.label = label;
        this.iconURL = iconURL;
    }

    public Suggestion(String id, String type, String label, String iconURL, String thumbnailURL) {
        this(id, type, label, iconURL);
        this.thumbnailURL = thumbnailURL;
    }

    public Suggestion(String id, String type, String label, String iconURL, String thumbnailURL, Map<String, List<String>> highlights) {
        this(id, type, label, iconURL);
        this.thumbnailURL = thumbnailURL;
        this.highlights = highlights;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getIconURL() {
        return this.iconURL;
    }

    public String getDescription() {
        return this.description;
    }

    public Suggestion withDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean getIsDisabled() {
        return this.disabled;
    }

    public String getThumbnailURL() {
        return this.thumbnailURL;
    }

    public Suggestion withHighlights(Map<String, List<String>> highlights) {
        this.highlights = highlights;
        return this;
    }

    public Suggestion withThumbnailURL(String thumbnailURL) {
        this.thumbnailURL = thumbnailURL;
        return this;
    }

    public Suggestion disable() {
        this.disabled = true;
        return this;
    }

    public abstract String getObjectUrl();

    public String toString() {
        return String.format("Suggestion(\"%s\", \"%s\", \"%s\")", this.type, this.label, this.iconURL);
    }

    public Map<String, List<String>> getHighlights() {
        return this.highlights;
    }
}

