/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.util.function.Consumer;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentImpl;
import org.nuxeo.ecm.platform.comment.api.ExternalEntity;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class CommentJsonReader
extends EntityJsonReader<Comment> {
    public CommentJsonReader() {
        super("comment");
    }

    protected Comment readEntity(JsonNode jn) {
        CommentImpl comment = new CommentImpl();
        return CommentJsonReader.fillCommentEntity(jn, (Comment)comment);
    }

    protected static Comment fillCommentEntity(JsonNode jn, Comment comment) {
        CommentJsonReader.setIfExist(jn, "parentId", arg_0 -> ((Comment)comment).setParentId(arg_0));
        CommentJsonReader.setIfExist(jn, "text", arg_0 -> ((Comment)comment).setText(arg_0));
        CommentJsonReader.setIfExist(jn, "creationDate", s -> comment.setCreationDate(s == null ? null : Instant.parse(s)));
        CommentJsonReader.setIfExist(jn, "modificationDate", s -> comment.setModificationDate(s == null ? null : Instant.parse(s)));
        if (jn.has("entityId") || jn.has("origin") || jn.has("entity")) {
            ExternalEntity externalEntity = (ExternalEntity)comment;
            CommentJsonReader.setIfExist(jn, "entityId", arg_0 -> ((ExternalEntity)externalEntity).setEntityId(arg_0));
            CommentJsonReader.setIfExist(jn, "origin", arg_0 -> ((ExternalEntity)externalEntity).setOrigin(arg_0));
            CommentJsonReader.setIfExist(jn, "entity", arg_0 -> ((ExternalEntity)externalEntity).setEntity(arg_0));
        }
        return comment;
    }

    protected static void setIfExist(JsonNode jn, String key, Consumer<String> consumer) {
        if (jn.has(key)) {
            consumer.accept(jn.get(key).textValue());
        }
    }
}

