/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.listener;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.listener.AbstractCommentListener;
import org.nuxeo.ecm.platform.comment.service.CommentServiceConfig;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.runtime.api.Framework;

public class DocumentRemovedCommentEventListener
extends AbstractCommentListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(DocumentRemovedCommentEventListener.class);

    @Override
    protected void doProcess(CoreSession coreSession, RelationManager relationManager, CommentServiceConfig config, DocumentModel docMessage) {
        log.debug((Object)"Processing relations cleanup on Document removal");
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        if (commentManager.hasFeature(CommentManager.Feature.COMMENTS_LINKED_WITH_PROPERTY)) {
            this.deleteCommentChildren(coreSession, commentManager, docMessage);
            coreSession.save();
        } else {
            DocumentRemovedCommentEventListener.onDocumentRemoved(coreSession, relationManager, config, docMessage);
        }
    }

    private static void onDocumentRemoved(CoreSession coreSession, RelationManager relationManager, CommentServiceConfig config, DocumentModel docMessage) {
        Resource documentRes = relationManager.getResource(config.documentNamespace, (Serializable)docMessage, null);
        if (documentRes == null) {
            log.error((Object)"Could not adapt document model to relation resource ; check the service relation adapters configuration");
            return;
        }
        Graph graph = relationManager.getGraph(config.graphName, coreSession);
        List statementList = graph.getStatements(null, null, (Node)documentRes);
        for (Statement stmt : statementList) {
            QNameResource resource = (QNameResource)stmt.getSubject();
            String commentId = resource.getLocalName();
            DocumentModel docModel = (DocumentModel)relationManager.getResourceRepresentation(config.commentNamespace, (Resource)resource, null);
            if (docModel != null) {
                try {
                    coreSession.removeDocument(docModel.getRef());
                    log.debug((Object)("comment removal succeded for id: " + commentId));
                }
                catch (DocumentNotFoundException e) {
                    log.error((Object)"comment removal failed", (Throwable)e);
                }
                continue;
            }
            log.warn((Object)("comment not found: id=" + commentId));
        }
        coreSession.save();
        graph.remove(statementList);
    }
}

