/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class AbstractLongRunningListener
implements PostCommitFilteringEventListener {
    protected static final Log log = LogFactory.getLog(AbstractLongRunningListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(EventBundle events) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (events instanceof ReconnectedEventBundleImpl) {
            boolean doContinue = false;
            ReconnectedEventBundleImpl preProcessBunle = new ReconnectedEventBundleImpl(events);
            try {
                doContinue = this.handleEventPreprocessing(preProcessBunle, data);
            }
            finally {
                preProcessBunle.disconnect();
            }
            if (!doContinue) {
                return;
            }
            TransactionHelper.commitOrRollbackTransaction();
            try {
                doContinue = this.handleEventLongRunning(((ReconnectedEventBundleImpl)events).getEventNames(), data);
            }
            finally {
                TransactionHelper.startTransaction();
            }
            if (!doContinue) {
                return;
            }
            ReconnectedEventBundleImpl postProcessEventBundle = new ReconnectedEventBundleImpl(events);
            try {
                this.handleEventPostprocessing(postProcessEventBundle, data);
            }
            finally {
                postProcessEventBundle.disconnect();
            }
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        } else {
            log.error((Object)"Unable to execute long running listener, input EventBundle is not a ReconnectedEventBundle");
        }
    }

    protected abstract boolean handleEventPreprocessing(EventBundle var1, Map<String, Object> var2);

    protected abstract boolean handleEventLongRunning(List<String> var1, Map<String, Object> var2);

    protected abstract void handleEventPostprocessing(EventBundle var1, Map<String, Object> var2);
}

