/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import java.io.Serializable;
import java.security.Principal;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import javax.security.auth.login.LoginException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.LoginService;
import org.nuxeo.runtime.api.login.NuxeoLoginContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class LoginComponent
extends DefaultComponent
implements LoginService {
    public static final String SYSTEM_USERNAME = "system";
    protected static final ThreadLocal<Deque<Principal>> PRINCIPAL_STACK = ThreadLocal.withInitial(() -> new LinkedList());

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (LoginService.class.isAssignableFrom(adapter)) {
            return (T)this;
        }
        return null;
    }

    protected NuxeoLoginContext systemLogin(String originatingUser) {
        SystemID principal = new SystemID(originatingUser);
        NuxeoLoginContext loginContext = NuxeoLoginContext.create(principal);
        loginContext.login();
        return loginContext;
    }

    @Override
    public NuxeoLoginContext login() {
        return this.systemLogin(null);
    }

    @Override
    public NuxeoLoginContext loginAs(String username) {
        return this.systemLogin(username);
    }

    @Override
    @Deprecated
    public NuxeoLoginContext login(String username, Object credentials) throws LoginException {
        return Framework.loginUser(username);
    }

    @Override
    public boolean isSystemId(Principal principal) {
        return LoginComponent.isSystemLogin(principal);
    }

    public static boolean isSystemLogin(Object principal) {
        return principal instanceof SystemID;
    }

    public static Deque<Principal> getPrincipalStack() {
        return PRINCIPAL_STACK.get();
    }

    public static void clearPrincipalStack() {
        PRINCIPAL_STACK.remove();
    }

    public static void pushPrincipal(Principal principal) {
        PRINCIPAL_STACK.get().addLast(principal);
    }

    public static Principal popPrincipal() {
        return PRINCIPAL_STACK.get().pollLast();
    }

    public static Principal getCurrentPrincipal() {
        return PRINCIPAL_STACK.get().peekLast();
    }

    public static class SystemID
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 2758247997191809993L;
        private final String userName;

        public SystemID() {
            this.userName = null;
        }

        public SystemID(String origUser) {
            this.userName = origUser == null ? LoginComponent.SYSTEM_USERNAME : origUser;
        }

        @Override
        public String getName() {
            return this.userName;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof SystemID) {
                SystemID other = (SystemID)object;
                return Objects.equals(this.userName, other.userName);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.userName == null ? 0 : this.userName.hashCode();
        }
    }
}

