/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.pdf.PDFTextExtractor;

@Operation(id="PDF.ExtractText", category="Document", label="PDF: Extract Text", description="Extracts raw text from a PDF. If the PDF is encrypted, a password is required. pdfxpath is the xpath of the blob (default to file:content). The extracted text is set in the targetxpath property of the input document, which is saved if save is true. If patterntofind is not provided, extracts all the text it can, else it extracts only the line where the pattern is found. If patterntofind is provided and removepatternfromresult is true, the line is returned without the pattern.")
public class PDFExtractTextOperation {
    public static final String ID = "PDF.ExtractText";
    @Context
    protected CoreSession session;
    @Param(name="pdfxpath", required=false)
    protected String pdfxpath = "file:content";
    @Param(name="save", required=false)
    protected boolean save = false;
    @Param(name="targetxpath", required=false)
    protected String targetxpath;
    @Param(name="patterntofind", required=false)
    protected String patterntofind;
    @Param(name="removepatternfromresult", required=false)
    protected boolean removepatternfromresult = false;
    @Param(name="password", required=false)
    protected String password = null;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel input) throws IOException {
        PDFTextExtractor textExtractor = new PDFTextExtractor(input, this.pdfxpath);
        textExtractor.setPassword(this.password);
        String extractedText = StringUtils.isBlank((CharSequence)this.patterntofind) ? textExtractor.getAllExtractedLines() : (this.removepatternfromresult ? textExtractor.extractLastPartOfLine(this.patterntofind) : textExtractor.extractLineOf(this.patterntofind));
        if (extractedText != null) {
            input.setPropertyValue(this.targetxpath, (Serializable)((Object)extractedText));
        } else {
            DocumentHelper.removeProperty((DocumentModel)input, (String)this.targetxpath);
        }
        if (this.save) {
            input = this.session.saveDocument(input);
        }
        return input;
    }
}

