/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.cache;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.cache.CachableBlobHolder;

public class SimpleCachableBlobHolder
extends SimpleBlobHolder
implements CachableBlobHolder {
    public SimpleCachableBlobHolder() {
    }

    public SimpleCachableBlobHolder(Blob blob) {
        super(blob);
    }

    public SimpleCachableBlobHolder(List<Blob> blobs) {
        super(blobs);
    }

    public SimpleCachableBlobHolder(String path) {
        super((Blob)new FileBlob(new File(path)));
    }

    @Override
    public void load(String path) throws IOException {
        this.blobs = new ArrayList();
        File base = new File(path);
        if (base.isDirectory()) {
            this.addDirectoryToList(base, "");
        } else {
            File file = new File(path);
            Blob mainBlob = Blobs.createBlob((File)file);
            mainBlob.setFilename(file.getName());
            this.blobs.add(mainBlob);
        }
        this.orderIndexPageFirst(this.blobs);
    }

    public void addDirectoryToList(File directory, String prefix) throws IOException {
        File[] directoryContent;
        for (File file : directoryContent = directory.listFiles()) {
            if (file.isDirectory()) {
                int beginIndex = ((String)prefix).length();
                prefix = (String)prefix + file.getName() + File.separatorChar;
                this.addDirectoryToList(file, (String)prefix);
                prefix = ((String)prefix).substring(0, beginIndex);
                continue;
            }
            Blob blob = Blobs.createBlob((File)file);
            blob.setFilename((String)prefix + file.getName());
            if (file.getName().equalsIgnoreCase("index.html")) {
                this.blobs.add(0, blob);
                continue;
            }
            this.blobs.add(blob);
        }
    }

    @Override
    public String persist(String basePath) throws IOException {
        if (this.blobs == null || this.blobs.isEmpty()) {
            return null;
        }
        Path path = new Path(basePath);
        path = path.append(this.getHash());
        if (this.blobs.size() == 1) {
            File file = new File(path.toString());
            this.getBlob().transferTo(file);
            return file.getAbsolutePath();
        }
        File dir = new File(path.toString());
        dir.mkdir();
        for (Blob blob : this.blobs) {
            File file = new File(path.append(blob.getFilename()).toString());
            blob.transferTo(file);
        }
        return dir.getAbsolutePath();
    }

    protected void orderIndexPageFirst(List<Blob> blobs) {
        Blob indexPage = null;
        for (Blob blob : blobs) {
            if (!blob.getFilename().contains("index.html") || indexPage != null && blob.getFilename().compareTo(indexPage.getFilename()) >= 0) continue;
            indexPage = blob;
        }
        if (indexPage != null) {
            blobs.remove(indexPage);
            blobs.add(0, indexPage);
        }
    }
}

