/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.resolver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

public interface ObjectResolver
extends Serializable {
    public static final String VALIDATION_PARAMETER_KEY = "validation";

    public void configure(Map<String, String> var1) throws IllegalArgumentException, IllegalStateException;

    public List<Class<?>> getManagedClasses();

    public String getName();

    public Map<String, Serializable> getParameters();

    public boolean validate(Object var1);

    default public boolean validate(Object value, Object context) {
        return this.validate(value);
    }

    public Object fetch(Object var1);

    default public Object fetch(Object value, Object context) {
        return this.fetch(value);
    }

    public <T> T fetch(Class<T> var1, Object var2);

    public Serializable getReference(Object var1);

    public String getConstraintErrorMessage(Object var1, Locale var2);

    public static final class Helper {
        private static final Log log = LogFactory.getLog(Helper.class);

        private Helper() {
        }

        public static String getConstraintErrorMessage(ObjectResolver resolver, String suffixCase, Object invalidValue, Locale locale, String ... additionnalParameters) {
            String message;
            ArrayList<String> pathTokens = new ArrayList<String>();
            pathTokens.add("label.schema.constraint.violation");
            pathTokens.add("resolver");
            pathTokens.add(resolver.getName());
            if (suffixCase != null) {
                pathTokens.add(suffixCase);
            }
            String keyConstraint = StringUtils.join(pathTokens, (char)'.');
            Object computedInvalidValue = "null";
            if (invalidValue != null) {
                String invalidValueString = invalidValue.toString();
                computedInvalidValue = invalidValueString.length() > 20 ? invalidValueString.substring(0, 15) + "..." : invalidValueString;
            }
            Object[] params = new Object[1 + additionnalParameters.length];
            params[0] = computedInvalidValue;
            System.arraycopy(additionnalParameters, 0, params, 1, params.length - 1);
            Locale computedLocale = locale != null ? locale : Constraint.MESSAGES_DEFAULT_LANG;
            try {
                message = I18NUtils.getMessageString((String)"messages", (String)keyConstraint, (Object[])params, (Locale)computedLocale);
            }
            catch (MissingResourceException e) {
                log.trace((Object)"No bundle found", (Throwable)e);
                return null;
            }
            if (message != null && !message.trim().isEmpty() && !keyConstraint.equals(message)) {
                return message;
            }
            return String.format("%s cannot resolve reference %s", resolver.getName(), computedInvalidValue);
        }

        public static String getConstraintErrorMessage(ObjectResolver resolver, Object invalidValue, Locale locale, String ... additionnalParameters) {
            return Helper.getConstraintErrorMessage(resolver, null, invalidValue, locale, additionnalParameters);
        }
    }
}

