/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.InvalidNameException;
import javax.naming.directory.Attributes;
import org.apache.commons.collections.MultiHashMap;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.RdnParser;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rdn
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String upName = null;
    private String normName = null;
    private int start;
    private int length;
    private Set<AttributeTypeAndValue> atavs = null;
    private Map<String, AttributeTypeAndValue> atavTypes = new MultiHashMap();
    private String atavType = null;
    protected AttributeTypeAndValue atav = null;
    private int nbAtavs = 0;
    public static final int UNDEFINED = Integer.MAX_VALUE;
    public static final int SUPERIOR = 1;
    public static final int INFERIOR = -1;
    public static final int EQUALS = 0;

    public Rdn() {
        this.upName = "";
        this.normName = "";
    }

    public Rdn(String rdn) throws InvalidNameException {
        this.start = 0;
        if (StringTools.isNotEmpty(rdn)) {
            RdnParser.parse(rdn, this);
            this.normalize();
            this.upName = rdn;
            this.length = rdn.length();
        } else {
            this.upName = "";
            this.normName = "";
            this.length = 0;
        }
    }

    public Rdn(String upType, String type, String upValue, String value) throws InvalidNameException {
        this.addAttributeTypeAndValue(upType, type, upValue, value);
        this.upName = type + '=' + value;
        this.start = 0;
        this.length = this.upName.length();
        this.normalize();
    }

    public Rdn(Rdn rdn) {
        this.nbAtavs = rdn.getNbAtavs();
        this.normName = rdn.normName;
        this.upName = rdn.getUpName();
        this.start = rdn.start;
        this.length = rdn.length;
        switch (rdn.getNbAtavs()) {
            case 0: {
                return;
            }
            case 1: {
                this.atav = (AttributeTypeAndValue)rdn.atav.clone();
                return;
            }
        }
        Iterator<AttributeTypeAndValue> iter = rdn.atavs.iterator();
        this.atavs = new TreeSet<AttributeTypeAndValue>();
        this.atavTypes = new MultiHashMap();
        while (iter.hasNext()) {
            AttributeTypeAndValue currentAtav = iter.next();
            this.atavs.add((AttributeTypeAndValue)currentAtav.clone());
            this.atavTypes.put(currentAtav.getUpType(), currentAtav);
        }
    }

    void normalize() {
        switch (this.nbAtavs) {
            case 0: {
                this.normName = "";
                break;
            }
            case 1: {
                if (this.atav.getValue() instanceof String) {
                    this.normName = this.atav.getNormalizedValue();
                    break;
                }
                this.normName = this.atav.getNormType() + "=#" + StringTools.dumpHexPairs((byte[])this.atav.getValue());
                break;
            }
            default: {
                StringBuffer sb = new StringBuffer();
                boolean isFirst = true;
                for (AttributeTypeAndValue ata : this.atavs) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append('+');
                    }
                    sb.append(ata.normalize());
                }
                this.normName = sb.toString();
            }
        }
    }

    void addAttributeTypeAndValue(String upType, String type, Object upValue, Object value) throws InvalidNameException {
        String normalizedType = StringTools.lowerCaseAscii(type);
        Object normalizedValue = value;
        switch (this.nbAtavs) {
            case 0: {
                this.atav = new AttributeTypeAndValue(upType, type, upValue, normalizedValue);
                this.nbAtavs = 1;
                this.atavType = normalizedType;
                return;
            }
            case 1: {
                this.atavs = new TreeSet<AttributeTypeAndValue>();
                this.atavs.add(this.atav);
                this.atavTypes = new MultiHashMap();
                this.atavTypes.put(this.atavType, this.atav);
                this.atav = null;
            }
        }
        AttributeTypeAndValue newAtav = new AttributeTypeAndValue(upType, type, upValue, normalizedValue);
        this.atavs.add(newAtav);
        this.atavTypes.put(normalizedType, newAtav);
        ++this.nbAtavs;
    }

    public void clear() {
        this.atav = null;
        this.atavs = null;
        this.atavType = null;
        this.atavTypes.clear();
        this.nbAtavs = 0;
        this.normName = "";
        this.upName = "";
        this.start = -1;
        this.length = 0;
    }

    public Object getValue(String type) throws InvalidNameException {
        String normalizedType = StringTools.lowerCaseAscii(StringTools.trim(type));
        switch (this.nbAtavs) {
            case 0: {
                return "";
            }
            case 1: {
                if (StringTools.equals(this.atav.getNormType(), normalizedType)) {
                    return this.atav.getValue();
                }
                return "";
            }
        }
        if (this.atavTypes.containsKey(normalizedType)) {
            AttributeTypeAndValue obj = this.atavTypes.get(normalizedType);
            if (obj instanceof AttributeTypeAndValue) {
                return obj.getValue();
            }
            if (obj instanceof List) {
                StringBuffer sb = new StringBuffer();
                boolean isFirst = true;
                for (int i = 0; i < ((List)((Object)obj)).size(); ++i) {
                    AttributeTypeAndValue elem = (AttributeTypeAndValue)((List)((Object)obj)).get(i);
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(elem.getValue());
                }
                return sb.toString();
            }
            throw new InvalidNameException("Bad object stored in the RDN");
        }
        return "";
    }

    public AttributeTypeAndValue getAttributeTypeAndValue(String type) {
        String normalizedType = StringTools.lowerCaseAscii(StringTools.trim(type));
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.atav.getNormType().equals(normalizedType)) {
                    return this.atav;
                }
                return null;
            }
        }
        if (this.atavTypes.containsKey(normalizedType)) {
            return this.atavTypes.get(normalizedType);
        }
        return null;
    }

    public Iterator<AttributeTypeAndValue> iterator() {
        if (this.nbAtavs == 1) {
            return new Iterator<AttributeTypeAndValue>(){
                private boolean hasMoreElement = true;

                @Override
                public boolean hasNext() {
                    return this.hasMoreElement;
                }

                @Override
                public AttributeTypeAndValue next() {
                    AttributeTypeAndValue obj = Rdn.this.atav;
                    this.hasMoreElement = false;
                    return obj;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.atavs.iterator();
    }

    public Object clone() {
        try {
            Rdn rdn = (Rdn)super.clone();
            switch (rdn.getNbAtavs()) {
                case 0: {
                    break;
                }
                case 1: {
                    rdn.atav = (AttributeTypeAndValue)this.atav.clone();
                    rdn.atavTypes = this.atavTypes;
                    break;
                }
                default: {
                    rdn.atavTypes = new MultiHashMap();
                    rdn.atavs = new TreeSet<AttributeTypeAndValue>();
                    for (AttributeTypeAndValue currentAtav : this.atavs) {
                        rdn.atavs.add((AttributeTypeAndValue)currentAtav.clone());
                        rdn.atavTypes.put(currentAtav.getUpType(), currentAtav);
                    }
                }
            }
            return rdn;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        if (object instanceof Rdn) {
            Rdn rdn = (Rdn)object;
            if (rdn.nbAtavs != this.nbAtavs) {
                return this.nbAtavs - rdn.nbAtavs;
            }
            switch (this.nbAtavs) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return this.atav.compareTo(rdn.atav);
                }
            }
            Iterator<AttributeTypeAndValue> i$ = this.atavs.iterator();
            if (i$.hasNext()) {
                AttributeTypeAndValue current = i$.next();
                String type = current.getNormType();
                if (rdn.atavTypes.containsKey(type)) {
                    List atavLocalList = (List)((Object)this.atavTypes.get(type));
                    List atavParamList = (List)((Object)rdn.atavTypes.get(type));
                    if (atavLocalList.size() == 1) {
                        AttributeTypeAndValue atavLocal = (AttributeTypeAndValue)atavLocalList.get(0);
                        AttributeTypeAndValue atavParam = (AttributeTypeAndValue)atavParamList.get(0);
                        return atavLocal.compareTo(atavParam);
                    }
                    for (AttributeTypeAndValue atavLocal : atavLocalList) {
                        Iterator atavParams = atavParamList.iterator();
                        boolean found = false;
                        while (atavParams.hasNext()) {
                            AttributeTypeAndValue atavParam = (AttributeTypeAndValue)atavParams.next();
                            if (atavLocal.compareTo(atavParam) != 0) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return this.normName == null ? "" : this.normName;
    }

    public String getUpName() {
        return this.upName;
    }

    public void setUpName(String upName) {
        this.upName = upName;
    }

    public int getNbAtavs() {
        return this.nbAtavs;
    }

    public AttributeTypeAndValue getAtav() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav;
            }
        }
        return (AttributeTypeAndValue)((TreeSet)this.atavs).first();
    }

    public String getUpType() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getUpType();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getUpType();
    }

    public String getNormType() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getNormType();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getNormType();
    }

    public Object getValue() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getValue();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getValue();
    }

    public Object getUpValue() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getUpValue();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getUpValue();
    }

    public boolean equals(Object rdn) {
        if (this == rdn) {
            return true;
        }
        if (!(rdn instanceof Rdn)) {
            return false;
        }
        return this.compareTo(rdn) == 0;
    }

    public int size() {
        return this.nbAtavs;
    }

    public Attributes toAttributes() {
        AttributesImpl attributes = new AttributesImpl(true);
        AttributeImpl attribute = null;
        switch (this.nbAtavs) {
            case 0: {
                break;
            }
            case 1: {
                attribute = new AttributeImpl(this.atavType, true);
                attribute.add(this.atav.getValue());
                attributes.put(attribute);
                break;
            }
            default: {
                for (String type : this.atavTypes.keySet()) {
                    List values = (List)((Object)this.atavTypes.get(type));
                    attribute = new AttributeImpl(type);
                    for (AttributeTypeAndValue value : values) {
                        attribute.add(value.getValue());
                    }
                    attributes.put(attribute);
                }
            }
        }
        return attributes;
    }

    public static Object unescapeValue(String value) throws IllegalArgumentException {
        if (StringTools.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        if (chars[0] == '#') {
            if (chars.length == 1) {
                return StringTools.EMPTY_BYTES;
            }
            if (chars.length % 2 != 1) {
                throw new IllegalArgumentException("This value is not in hex form, we have an odd number of hex chars");
            }
            byte[] hexValue = new byte[(chars.length - 1) / 2];
            int pos = 0;
            for (int i = 1; i < chars.length; i += 2) {
                if (!StringTools.isHex(chars, i) || !StringTools.isHex(chars, i + 1)) {
                    throw new IllegalArgumentException("This value is not in hex form");
                }
                hexValue[pos++] = StringTools.getHexValue(chars[i], chars[i + 1]);
            }
            return hexValue;
        }
        boolean escaped = false;
        boolean isHex = false;
        int pair = -1;
        int pos = 0;
        byte[] bytes = new byte[chars.length * 6];
        block8: for (int i = 0; i < chars.length; ++i) {
            if (escaped) {
                escaped = false;
                switch (chars[i]) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': {
                        bytes[pos++] = (byte)chars[i];
                        break;
                    }
                    default: {
                        if (!StringTools.isHex(chars, i)) continue block8;
                        isHex = true;
                        pair = (byte)(StringTools.getHexValue(chars[i]) << 4);
                        break;
                    }
                }
                continue;
            }
            if (isHex) {
                if (!StringTools.isHex(chars, i)) continue;
                pair = (byte)(pair + StringTools.getHexValue(chars[i]));
                bytes[pos++] = pair;
                continue;
            }
            switch (chars[i]) {
                case '\\': {
                    escaped = true;
                    continue block8;
                }
                case ' ': 
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': {
                    throw new IllegalArgumentException("Unescaped special characters are not allowed");
                }
                default: {
                    byte[] result = StringTools.charToBytes(chars[i]);
                    for (int j = 0; j < result.length; ++j) {
                        bytes[pos++] = result[j];
                    }
                }
            }
        }
        return StringTools.utf8ToString(bytes, pos);
    }

    public static String escapeValue(String value) {
        if (StringTools.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        char[] newChars = new char[chars.length * 3];
        int pos = 0;
        block6: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case ' ': 
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i];
                    continue block6;
                }
                case '\u007f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 55;
                    newChars[pos++] = 70;
                    continue block6;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 48;
                    newChars[pos++] = StringTools.dumpHex((byte)(chars[i] & 0xF));
                    continue block6;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 49;
                    newChars[pos++] = StringTools.dumpHex((byte)(chars[i] & 0xF));
                    continue block6;
                }
                default: {
                    newChars[pos++] = chars[i];
                }
            }
        }
        return new String(newChars, 0, pos);
    }

    public static String escapeValue(byte[] attrValue) {
        if (StringTools.isEmpty(attrValue)) {
            return "";
        }
        String value = StringTools.utf8ToString(attrValue);
        return Rdn.escapeValue(value);
    }

    public int hashCode() {
        int result = 17;
        switch (this.nbAtavs) {
            case 0: {
                break;
            }
            case 1: {
                result = result * 37 + this.atav.hashCode();
                break;
            }
            default: {
                for (AttributeTypeAndValue ata : this.atavs) {
                    result = result * 37 + ata.hashCode();
                }
            }
        }
        return result;
    }
}

