/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.ModuleResource;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;

@Deprecated
public class WebException
extends WebApplicationException {
    protected static final Log log = LogFactory.getLog(WebException.class);
    private static final long serialVersionUID = 176876876786L;
    protected String type;
    protected Throwable cause;
    protected String message;
    protected int status;

    public WebException() {
    }

    public WebException(Response response) {
        super(response);
    }

    public WebException(int status) {
        super(status);
        this.status = status;
    }

    public WebException(Response.Status status) {
        super(status);
        this.status = status.getStatusCode();
    }

    protected WebException(Throwable cause, Response.Status status) {
        super(cause, status);
        this.cause = cause;
        this.status = status.getStatusCode();
    }

    protected WebException(Throwable cause, int status) {
        super(cause, status);
        this.cause = cause;
        this.status = status;
    }

    protected WebException(Throwable cause) {
        super(cause);
        this.cause = cause;
    }

    public WebException(String message) {
        this.message = message;
    }

    public WebException(String message, int code) {
        super(code);
        this.message = message;
        this.status = code;
    }

    public WebException(String message, Throwable cause, int status) {
        if (cause == null) {
            throw new IllegalArgumentException("the cause parameter cannot be null");
        }
        this.status = status == -1 ? WebException.getStatus(cause) : status;
        this.cause = cause;
        this.message = message == null ? cause.getMessage() : message;
        this.type = cause.getClass().getName();
    }

    public WebException(String message, Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException("the cause parameter cannot be null");
        }
        this.status = WebException.getStatus(cause);
        this.cause = cause;
        this.message = message == null ? cause.getMessage() : message;
        this.type = cause.getClass().getName();
    }

    public static WebException newException(String message, Throwable cause) {
        return WebException.newException(message, cause, -1);
    }

    public static WebException newException(Throwable cause) {
        return WebException.newException(null, cause);
    }

    public static WebException newException(String message, Throwable cause, int status) {
        if (cause == null) {
            throw new IllegalArgumentException("the cause parameter cannot be null");
        }
        return new WebException(message, cause, status);
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static WebException wrap(Throwable e) {
        return WebException.wrap(null, e);
    }

    public static WebException wrap(String message, Throwable exception) {
        if (exception instanceof Exception) {
            ExceptionUtils.checkInterrupt((Exception)((Exception)exception));
        }
        if (exception instanceof DocumentSecurityException) {
            return new WebException(message, exception, Response.Status.FORBIDDEN.getStatusCode());
        }
        if (exception instanceof WebException) {
            return (WebException)((Object)exception);
        }
        if (exception instanceof DocumentNotFoundException) {
            return new WebException(message, exception, Response.Status.NOT_FOUND.getStatusCode());
        }
        return new WebException(message, exception);
    }

    public static Object handleError(WebApplicationException e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return Response.status((int)500).entity((Object)sw.toString()).build();
    }

    public static int getStatus(Throwable cause) {
        return WebException.getStatus(cause, 8);
    }

    public static int getStatus(Throwable cause, int depth) {
        if (depth == 0) {
            log.warn((Object)"Possible infinite loop! Check the exception wrapping.");
            return 500;
        }
        if (cause instanceof DocumentSecurityException || cause instanceof SecurityException) {
            return 403;
        }
        if (cause instanceof DocumentNotFoundException || cause instanceof WebResourceNotFoundException) {
            return 404;
        }
        if (cause instanceof WebSecurityException) {
            return 401;
        }
        Throwable parent = cause.getCause();
        if (parent == cause) {
            log.warn((Object)"Infinite loop detected! Check the exception wrapping.");
            return 500;
        }
        if (parent != null) {
            return WebException.getStatus(parent, depth - 1);
        }
        if (cause.getMessage() != null && cause.getMessage().contains(DocumentNotFoundException.class.getName())) {
            log.warn((Object)"Badly wrapped exception: found a DocumentNotFoundException message but no DocumentNotFoundException", cause);
            return 404;
        }
        return 500;
    }

    public static boolean isSecurityError(Throwable t) {
        return WebException.getStatus(t) == 403;
    }

    @Deprecated
    public static Response toResponse(Throwable t) {
        return new WebException(t).toResponse();
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatusCode() {
        return this.status;
    }

    public String getStackTraceString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    @Deprecated
    public int getReturnCode() {
        return super.getResponse().getStatus();
    }

    public Response toResponse() {
        WebContext ctx = WebEngine.getActiveContext();
        if (ctx != null && ctx.head() instanceof ModuleResource) {
            return this.toWebModuleResponse(ctx);
        }
        return Response.status((int)this.status).entity((Object)this).build();
    }

    protected Response toWebModuleResponse(WebContext ctx) {
        ModuleResource mr = (ModuleResource)ctx.head();
        Object result = mr.handleError(this.getCause());
        if (result instanceof Response) {
            return (Response)result;
        }
        if (result instanceof WebException) {
            this.status = ((WebException)((Object)result)).getStatus();
        }
        return Response.fromResponse((Response)this.getResponse()).status(this.status).entity(result).build();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getRequestId() {
        return "";
    }

    public String getHelpUrl() {
        return "";
    }
}

