/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.validation.DocumentValidationException;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.ModuleResource;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Provider
public class WebEngineExceptionMapper
implements ExceptionMapper<Throwable> {
    @Context
    HttpHeaders headers;
    protected static final Log log = LogFactory.getLog(WebEngineExceptionMapper.class);

    public Response toResponse(Throwable cause) {
        TransactionHelper.setTransactionRollbackOnly();
        if (this.headers.getAcceptableMediaTypes().contains(MediaType.APPLICATION_JSON_TYPE) && cause instanceof DocumentValidationException) {
            DocumentValidationException dve = (DocumentValidationException)cause;
            return Response.status((int)dve.getStatusCode()).entity((Object)dve.getReport()).build();
        }
        if (cause instanceof WebException) {
            return ((WebException)((Object)cause)).toResponse();
        }
        Object result = WebEngineExceptionMapper.handleErrorOnWebModule(cause);
        if (result instanceof Throwable) {
            cause = (Throwable)result;
        } else {
            if (result instanceof Response) {
                return (Response)result;
            }
            if (result != null) {
                return Response.status((int)500).entity(result).build();
            }
        }
        int statusCode = WebEngineExceptionMapper.getStatusCode(cause);
        if (statusCode >= 500) {
            log.error((Object)cause, cause);
        } else {
            log.debug((Object)cause, cause);
        }
        return Response.status((int)statusCode).entity((Object)(cause instanceof NuxeoException ? cause : new NuxeoException(cause, statusCode))).build();
    }

    protected static int getStatusCode(Throwable t) {
        if (t instanceof WebException) {
            WebException webException = (WebException)((Object)t);
            return webException.getStatusCode();
        }
        if (t instanceof WebApplicationException) {
            WebApplicationException e = (WebApplicationException)t;
            return e.getResponse().getStatus();
        }
        if (t instanceof NuxeoException) {
            NuxeoException e = (NuxeoException)t;
            return e.getStatusCode();
        }
        if (t instanceof SecurityException) {
            return 403;
        }
        Throwable cause = t.getCause();
        if (cause == null || t == cause) {
            return 500;
        }
        return WebEngineExceptionMapper.getStatusCode(cause);
    }

    protected static Object handleErrorOnWebModule(Throwable t) {
        WebContext ctx = WebEngine.getActiveContext();
        if (ctx != null && ctx.head() instanceof ModuleResource) {
            ModuleResource mr = (ModuleResource)ctx.head();
            return mr.handleError(t);
        }
        return null;
    }
}

