/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.annotations;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.runtime.annotations.AnnotatedClass;
import org.nuxeo.runtime.annotations.AnnotatedMethod;
import org.nuxeo.runtime.annotations.MethodAnnotations;

public class AnnotationManager {
    protected Map<Class<?>, AnnotatedClass<?>> classCache = this.createCache();

    protected Map<Class<?>, AnnotatedClass<?>> createCache() {
        return new ConcurrentHashMap();
    }

    public void flushCache() {
        this.classCache = this.createCache();
    }

    public <T> AnnotatedClass<T> getAnnotatedClass(Class<T> clazz) {
        Map<Class<?>, AnnotatedClass<?>> cache = this.classCache;
        AnnotatedClass<Object> aclass = cache.get(clazz);
        if (aclass == null) {
            aclass = this.load(clazz);
            cache.put(clazz, aclass);
        }
        return aclass;
    }

    public <T> AnnotatedClass<T> lookup(Class<T> clazz) {
        return this.classCache.get(clazz);
    }

    public <T> AnnotatedClass<T> load(Class<T> clazz) {
        AnnotatedClass<T> aclass = new AnnotatedClass<T>(clazz);
        Class<T> zuper = clazz.getSuperclass();
        MethodAnnotations mannos = new MethodAnnotations();
        if (zuper != null) {
            AnnotatedClass<T> azuper = this.getAnnotatedClass(zuper);
            aclass.annotations.putAll(azuper.annotations);
            AnnotatedMethod[] annotatedMethodArray = azuper.getAnnotatedMethods();
            int n = annotatedMethodArray.length;
            for (int i = 0; i < n; ++i) {
                AnnotatedMethod am = annotatedMethodArray[i];
                mannos.addSuperMethod(am);
            }
        }
        for (Class<?> itf : clazz.getInterfaces()) {
            AnnotatedClass<?> aitf = this.getAnnotatedClass(itf);
            aclass.annotations.putAll(aitf.annotations);
            for (AnnotatedMethod am : aitf.getAnnotatedMethods()) {
                mannos.addSuperMethod(am);
            }
        }
        mannos.addMethods(clazz);
        for (Annotation anno : clazz.getAnnotations()) {
            aclass.annotations.put(anno.annotationType(), anno);
        }
        for (MethodAnnotations.Entry entry : mannos.entries) {
            AnnotatedMethod am = new AnnotatedMethod(aclass, entry.method, entry.annos);
            aclass.addMethod(am);
        }
        return aclass;
    }
}

