/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.io.enrichers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class RunnableWorkflowJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "runnableWorkflows";
    @Inject
    ActionManager actionManager;

    public RunnableWorkflowJsonEnricher() {
        super(NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        jg.writeFieldName(NAME);
        jg.writeStartArray();
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            DocumentRoutingService documentRoutingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
            List routeModels = documentRoutingService.searchRouteModels(wrapper.getSession(), "");
            ELActionContext actionContext = new ELActionContext();
            actionContext.setCurrentDocument(document);
            actionContext.setDocumentManager(wrapper.getSession());
            actionContext.setCurrentPrincipal(wrapper.getSession().getPrincipal());
            Iterator it = routeModels.iterator();
            while (it.hasNext()) {
                DocumentModel route = (DocumentModel)it.next();
                Object graphRouteObj = route.getAdapter(GraphRoute.class);
                if (graphRouteObj instanceof GraphRoute) {
                    String filter = ((GraphRoute)graphRouteObj).getAvailabilityFilter();
                    if (StringUtils.isBlank((CharSequence)filter) || this.actionManager.checkFilter(filter, (ActionContext)actionContext)) continue;
                    it.remove();
                    continue;
                }
                it.remove();
            }
            for (DocumentModel documentRoute : routeModels) {
                this.writeEntity(documentRoute.getAdapter(DocumentRoute.class), jg);
            }
        }
        finally {
            jg.writeEndArray();
        }
    }
}

