/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.collections;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;

@Operation(id="Document.AddToCollection", category="Document", label="Add document to collection", description="Add a list of documents in a collection. No value is returned.", aliases={"Collection.AddToCollection"})
public class AddToCollectionOperation {
    public static final String ID = "Document.AddToCollection";
    @Context
    protected CoreSession session;
    @Context
    protected CollectionManager collectionManager;
    @Param(name="collection")
    protected DocumentModel collection;

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        for (DocumentModel doc : docs) {
            this.collectionManager.addToCollection(this.collection, doc, this.session);
        }
        return docs;
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        this.collectionManager.addToCollection(this.collection, doc, this.session);
        return doc;
    }
}

