/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.directory;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.directory.AbstractDirectoryOperation;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Operation(id="Directory.ReadEntries", category="Services", label="Reads directory entries", description="Reads directory entries. Entries ids to read are sent as a JSON array. Returns the entries as a JSON array of JSON objects containing all fields.", addToStudio=false)
public class ReadDirectoryEntries
extends AbstractDirectoryOperation {
    public static final String ID = "Directory.ReadEntries";
    @Context
    protected OperationContext ctx;
    @Context
    protected DirectoryService directoryService;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="directoryName", required=true)
    protected String directoryName;
    @Param(name="entries", required=true)
    protected String jsonEntries;
    @Param(name="translateLabels", required=false)
    protected boolean translateLabels;
    @Param(name="lang", required=false)
    protected String lang;

    @OperationMethod
    public Blob run() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        List ids = (List)mapper.readValue(this.jsonEntries, (TypeReference)new TypeReference<List<String>>(){});
        ArrayList entries = new ArrayList();
        Directory directory = this.directoryService.getDirectory(this.directoryName);
        String schemaName = directory.getSchema();
        Schema schema = this.schemaManager.getSchema(schemaName);
        try (Session session = this.directoryService.open(this.directoryName);){
            for (String id : ids) {
                DocumentModel entry = session.getEntry(id);
                if (entry == null) continue;
                HashMap<String, Serializable> m = new HashMap<String, Serializable>();
                for (Field field : schema.getFields()) {
                    QName fieldName = field.getName();
                    String key = fieldName.getLocalName();
                    Object value = entry.getPropertyValue(fieldName.getPrefixedName());
                    if (this.translateLabels && "label".equals(key)) {
                        value = this.translate((String)value);
                    }
                    m.put(key, (Serializable)value);
                }
                entries.add(m);
            }
        }
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, entries);
        return Blobs.createJSONBlob((String)writer.toString());
    }

    protected Locale getLocale() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
        }
        if (this.lang == null) {
            this.lang = "en";
        }
        return new Locale(this.lang);
    }

    protected String translate(String key) {
        if (key == null) {
            return "";
        }
        return I18NUtils.getMessageString((String)"messages", (String)key, (Object[])new Object[0], (Locale)this.getLocale());
    }
}

