/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.nuxeo.ecm.platform.el.ExpressionResolver;

public class ExpressionContext
extends ELContext {
    protected final ELResolver resolver = new ExpressionResolver();
    protected final FunctionMapper functionMapper = new MyFunctionMapper();
    protected final VariableMapper variableMapper = new MyVariableMapper();

    public ELResolver getELResolver() {
        return this.resolver;
    }

    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    public VariableMapper getVariableMapper() {
        return this.variableMapper;
    }

    private static class MyFunctionMapper
    extends FunctionMapper {
        private final Map<String, Method> map = new HashMap<String, Method>();

        private MyFunctionMapper() {
        }

        public Method resolveFunction(String prefix, String localName) {
            return this.map.get(prefix + ":" + localName);
        }
    }

    private static class MyVariableMapper
    extends VariableMapper {
        protected final Map<String, ValueExpression> map = new HashMap<String, ValueExpression>();

        private MyVariableMapper() {
        }

        public ValueExpression resolveVariable(String variable) {
            return this.map.get(variable);
        }

        public ValueExpression setVariable(String variable, ValueExpression expression) {
            return this.map.put(variable, expression);
        }
    }
}

