/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.codec;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.message.RawMessageDecoder;
import org.apache.avro.message.RawMessageEncoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.StreamRuntimeException;
import org.nuxeo.lib.stream.codec.Codec;

public class AvroConfluentCodec<T>
implements Codec<T> {
    private static final Log log = LogFactory.getLog(AvroConfluentCodec.class);
    public static final String NAME = "avroConfluent";
    protected static final byte MAGIC_BYTE = 0;
    protected static final int ID_SIZE = 4;
    protected static final int DEFAULT_IDENTITY_MAP_CAPACITY = 10;
    protected final Class<T> messageClass;
    protected final Schema schema;
    protected final int schemaId;
    protected final String schemaName;
    protected final KafkaAvroSerializer serializer;
    protected final RawMessageEncoder<T> encoder;
    protected final SchemaRegistryClient client;

    public AvroConfluentCodec(Class<T> messageClass, String schemaRegistryUrls) {
        this.messageClass = messageClass;
        this.schema = ReflectData.get().getSchema(messageClass);
        this.schemaName = messageClass.getName();
        this.client = schemaRegistryUrls.contains(",") ? new CachedSchemaRegistryClient(Arrays.asList(schemaRegistryUrls.split(",")), 10) : new CachedSchemaRegistryClient(schemaRegistryUrls, 10);
        try {
            this.schemaId = this.client.register(messageClass.getName(), this.schema);
        }
        catch (RestClientException | IOException e) {
            throw new StreamRuntimeException(e);
        }
        this.serializer = new KafkaAvroSerializer(this.client);
        this.encoder = new RawMessageEncoder((GenericData)ReflectData.get(), this.schema);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] encode(T object) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(0);
        try {
            out.write(ByteBuffer.allocate(4).putInt(this.schemaId).array());
            out.write(this.encoder.encode(object).array());
        }
        catch (IOException e) {
            throw new StreamRuntimeException(e);
        }
        return out.toByteArray();
    }

    @Override
    public T decode(byte[] data) {
        Schema writeSchema;
        ByteBuffer buffer = ByteBuffer.wrap(data);
        if (buffer.get() != 0) {
            throw new IllegalArgumentException("Invalid Avro Confluent message, expecting magic byte");
        }
        int id = buffer.getInt();
        try {
            writeSchema = this.client.getById(id);
        }
        catch (IOException e) {
            throw new StreamRuntimeException("Cannot retrieve write schema id: " + id + " on " + this.messageClass, e);
        }
        catch (RestClientException e) {
            if (e.getStatus() != 404) {
                throw new StreamRuntimeException("Cannot retrieve write schema id: " + id + " on " + this.messageClass, e);
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Cannot retrieve write schema %d, fallback to read schema: %d for %s", id, this.schemaId, this.messageClass));
            }
            writeSchema = this.schema;
        }
        RawMessageDecoder decoder = new RawMessageDecoder((GenericData)ReflectData.get(), writeSchema, this.schema);
        try {
            return (T)decoder.decode(buffer.slice(), null);
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

