/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.kafka;

import java.io.Externalizable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.log.LogLag;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.RebalanceListener;
import org.nuxeo.lib.stream.log.internals.AbstractLogManager;
import org.nuxeo.lib.stream.log.internals.CloseableLogAppender;
import org.nuxeo.lib.stream.log.kafka.KafkaLogAppender;
import org.nuxeo.lib.stream.log.kafka.KafkaLogTailer;
import org.nuxeo.lib.stream.log.kafka.KafkaNamespace;
import org.nuxeo.lib.stream.log.kafka.KafkaUtils;

public class KafkaLogManager
extends AbstractLogManager {
    public static final String DISABLE_SUBSCRIBE_PROP = "subscribe.disable";
    public static final String DEFAULT_REPLICATION_FACTOR_PROP = "default.replication.factor";
    protected final KafkaUtils kUtils;
    protected final Properties producerProperties;
    protected final Properties consumerProperties;
    protected final Properties adminProperties;
    protected final String prefix;
    protected final short defaultReplicationFactor;
    protected final boolean disableSubscribe;
    protected final KafkaNamespace ns;

    @Deprecated
    public KafkaLogManager(String zkServers, String prefix, Properties producerProperties, Properties consumerProperties) {
        this(prefix, producerProperties, consumerProperties);
    }

    public KafkaLogManager(String prefix, Properties producerProperties, Properties consumerProperties) {
        this.prefix = prefix != null ? prefix : "";
        this.ns = new KafkaNamespace(this.prefix);
        this.disableSubscribe = Boolean.valueOf(consumerProperties.getProperty(DISABLE_SUBSCRIBE_PROP, "false"));
        this.defaultReplicationFactor = Short.parseShort(producerProperties.getProperty(DEFAULT_REPLICATION_FACTOR_PROP, "1"));
        this.producerProperties = this.normalizeProducerProperties(producerProperties);
        this.consumerProperties = this.normalizeConsumerProperties(consumerProperties);
        this.adminProperties = this.createAdminProperties(producerProperties);
        this.kUtils = new KafkaUtils(this.adminProperties);
    }

    @Override
    public void create(String name, int size) {
        this.kUtils.createTopic(this.ns.getTopicName(name), size, this.defaultReplicationFactor);
    }

    @Override
    protected int getSize(String name) {
        return this.kUtils.partitions(this.ns.getTopicName(name));
    }

    @Override
    public boolean exists(String name) {
        return this.kUtils.topicExists(this.ns.getTopicName(name));
    }

    @Override
    public <M extends Externalizable> CloseableLogAppender<M> createAppender(String name, Codec<M> codec) {
        return KafkaLogAppender.open(codec, this.ns, name, this.producerProperties, this.consumerProperties);
    }

    @Override
    protected <M extends Externalizable> LogTailer<M> doCreateTailer(Collection<LogPartition> partitions, String group, Codec<M> codec) {
        partitions.forEach(this::checkValidPartition);
        return KafkaLogTailer.createAndAssign(codec, this.ns, partitions, group, (Properties)this.consumerProperties.clone());
    }

    protected void checkValidPartition(LogPartition partition) {
        int partitions = this.kUtils.getNumberOfPartitions(this.ns.getTopicName(partition.name()));
        if (partition.partition() >= partitions) {
            throw new IllegalArgumentException("Partition out of bound " + partition + " max: " + partitions);
        }
    }

    public Properties getProducerProperties() {
        return this.producerProperties;
    }

    public Properties getConsumerProperties() {
        return this.consumerProperties;
    }

    public Properties getAdminProperties() {
        return this.adminProperties;
    }

    @Override
    public void close() {
        super.close();
        if (this.kUtils != null) {
            this.kUtils.close();
        }
    }

    @Override
    public boolean supportSubscribe() {
        return !this.disableSubscribe;
    }

    @Override
    protected <M extends Externalizable> LogTailer<M> doSubscribe(String group, Collection<String> names, RebalanceListener listener, Codec<M> codec) {
        return KafkaLogTailer.createAndSubscribe(codec, this.ns, names, group, (Properties)this.consumerProperties.clone(), listener);
    }

    protected Properties normalizeProducerProperties(Properties producerProperties) {
        Properties ret = producerProperties != null ? (Properties)producerProperties.clone() : new Properties();
        ret.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        ret.put("value.serializer", "org.apache.kafka.common.serialization.BytesSerializer");
        ret.remove(DEFAULT_REPLICATION_FACTOR_PROP);
        return ret;
    }

    protected Properties normalizeConsumerProperties(Properties consumerProperties) {
        Properties ret = consumerProperties != null ? (Properties)consumerProperties.clone() : new Properties();
        ret.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        ret.put("value.deserializer", "org.apache.kafka.common.serialization.BytesDeserializer");
        ret.put("enable.auto.commit", (Object)false);
        ret.put("auto.offset.reset", "earliest");
        ret.remove(DISABLE_SUBSCRIBE_PROP);
        return ret;
    }

    protected Properties createAdminProperties(Properties producerProperties) {
        Properties ret = new Properties();
        block15: for (Map.Entry<Object, Object> prop : producerProperties.entrySet()) {
            switch (prop.getKey().toString()) {
                case "acks": 
                case "batch.size": 
                case "buffer.memory": 
                case "compression.type": 
                case "key.serializer": 
                case "linger.ms": 
                case "max.block.ms": 
                case "value.serializer": 
                case "delivery.timeout.ms": 
                case "default.replication.factor": {
                    continue block15;
                }
            }
            ret.put(prop.getKey(), prop.getValue());
        }
        return ret;
    }

    @Override
    public synchronized List<LogLag> getLagPerPartition(String name, String group) {
        Properties props = (Properties)this.consumerProperties.clone();
        props.put("group.id", this.prefix + group);
        props.put("client.id", "lag");
        try (KafkaConsumer consumer = new KafkaConsumer(props);){
            List topicPartitions = consumer.partitionsFor(this.ns.getTopicName(name)).stream().map(meta -> new TopicPartition(meta.topic(), meta.partition())).collect(Collectors.toList());
            LogLag[] ret = new LogLag[topicPartitions.size()];
            Map endOffsets = consumer.endOffsets(topicPartitions);
            for (TopicPartition topicPartition : topicPartitions) {
                Long endOffset;
                long committedOffset = 0L;
                OffsetAndMetadata committed = consumer.committed(topicPartition);
                if (committed != null) {
                    committedOffset = committed.offset();
                }
                if ((endOffset = (Long)endOffsets.get(topicPartition)) == null) {
                    endOffset = 0L;
                }
                ret[topicPartition.partition()] = new LogLag(committedOffset, endOffset);
            }
            List<LogLag> list = Arrays.asList(ret);
            return list;
        }
    }

    @Override
    public List<String> listAll() {
        return this.kUtils.listTopics().stream().filter(name -> name.startsWith(this.prefix)).map(this.ns::getLogName).collect(Collectors.toList());
    }

    public String toString() {
        return "KafkaLogManager{producerProperties=" + this.filterDisplayedProperties(this.producerProperties) + ", consumerProperties=" + this.filterDisplayedProperties(this.consumerProperties) + ", prefix='" + this.prefix + "'}";
    }

    protected String filterDisplayedProperties(Properties properties) {
        String ret = properties.toString();
        if (ret.indexOf("password") < 0) {
            return ret;
        }
        return ret.replaceAll("password=.[^\\\"\\;\\,\\ ]*", "password=****");
    }

    @Override
    public List<String> listConsumerGroups(String name) {
        String topic = this.ns.getTopicName(name);
        if (!this.exists(name)) {
            throw new IllegalArgumentException("Unknown Log: " + name);
        }
        return this.kUtils.listConsumers(topic).stream().filter(group -> group.startsWith(this.prefix)).map(this.ns::getGroup).collect(Collectors.toList());
    }
}

