/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;

@Operation(id="Document.Subscribe", category="Document", label="Subscribe document", description="Subscribe one or more documents. No value is returned.")
public class SubscribeOperation {
    public static final String ID = "Document.Subscribe";
    @Context
    protected CoreSession coreSession;
    @Context
    protected NotificationManager notificationManager;
    @Param(name="notifications", required=false)
    protected StringList notifications;

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        docs.forEach(this::run);
        return docs;
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        NuxeoPrincipal principal = this.coreSession.getPrincipal();
        String username = "user:" + principal.getName();
        if (this.notifications == null || this.notifications.isEmpty()) {
            this.notificationManager.addSubscriptions(username, doc, Boolean.valueOf(false), principal);
        } else {
            for (String notification : this.notifications) {
                this.notificationManager.addSubscription(username, notification, doc, Boolean.valueOf(false), principal, notification);
            }
        }
        return doc;
    }
}

