/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ESClientFactory;
import org.nuxeo.elasticsearch.api.ESHintQueryBuilder;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.config.ESHintQueryBuilderDescriptor;
import org.nuxeo.elasticsearch.config.ElasticSearchClientConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchEmbeddedServerConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchIndexConfig;
import org.nuxeo.elasticsearch.core.ElasticSearchEmbeddedNode;
import org.nuxeo.runtime.api.Framework;

public class ElasticSearchAdminImpl
implements ElasticSearchAdmin {
    private static final Logger log = LogManager.getLogger(ElasticSearchAdminImpl.class);
    protected static final int TIMEOUT_WAIT_FOR_CLUSTER_SECOND = 30;
    protected static final int TIMEOUT_DELETE_SECOND = 300;
    protected final AtomicInteger totalCommandProcessed = new AtomicInteger(0);
    protected final Map<String, String> indexNames = new HashMap<String, String>();
    protected final Map<String, String> repoNames = new HashMap<String, String>();
    protected final Map<String, String> writeIndexNames = new HashMap<String, String>();
    protected final Map<String, ElasticSearchIndexConfig> indexConfig;
    protected Map<String, ESHintQueryBuilder> hints;
    protected final ElasticSearchEmbeddedServerConfig embeddedServerConfig;
    protected final ElasticSearchClientConfig clientConfig;
    protected ElasticSearchEmbeddedNode embeddedServer;
    protected ESClient client;
    protected boolean indexInitDone;
    protected String[] includeSourceFields;
    protected String[] excludeSourceFields;
    protected List<String> repositoryInitialized = new ArrayList<String>();

    public ElasticSearchAdminImpl(ElasticSearchEmbeddedServerConfig embeddedServerConfig, ElasticSearchClientConfig clientConfig, Map<String, ElasticSearchIndexConfig> indexConfig, Collection<ESHintQueryBuilderDescriptor> hintDescriptors) {
        this.embeddedServerConfig = embeddedServerConfig;
        this.indexConfig = indexConfig;
        this.clientConfig = clientConfig;
        this.hints = hintDescriptors.stream().collect(Collectors.toMap(ESHintQueryBuilderDescriptor::getName, ESHintQueryBuilderDescriptor::newInstance));
        this.checkConfig();
        this.connect();
        this.initializeIndexes();
    }

    protected void checkConfig() {
        if (this.clientConfig == null) {
            throw new IllegalStateException("No Elasticsearch Client configuration provided, aborting");
        }
    }

    protected void connect() {
        if (this.client != null) {
            return;
        }
        if (this.embeddedServerConfig != null) {
            this.embeddedServer = new ElasticSearchEmbeddedNode(this.embeddedServerConfig);
            this.embeddedServer.start();
        }
        this.client = this.createClient(this.embeddedServer);
        try {
            this.checkClusterHealth(new String[0]);
            log.info("Elasticsearch Connected");
        }
        catch (Exception e) {
            this.disconnect();
            throw new IllegalStateException("Unable to check cluster health", e);
        }
    }

    public void disconnect() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e) {
                log.error("Failed to close client: " + e.getMessage(), (Throwable)e);
            }
            this.client = null;
            this.indexInitDone = false;
            log.info("Elasticsearch Disconnected");
        }
        if (this.embeddedServer != null) {
            try {
                this.embeddedServer.close();
            }
            catch (IOException e) {
                log.error("Failed to close embedded node: {}", (Object)e.getMessage(), (Object)e);
            }
            this.embeddedServer = null;
            log.info("Elasticsearch embedded Node Stopped");
        }
    }

    protected ESClient createClient(ElasticSearchEmbeddedNode node) {
        ESClient ret;
        log.info("Connecting to Elasticsearch");
        try {
            ESClientFactory clientFactory = this.clientConfig.getKlass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ret = clientFactory.create(node, this.clientConfig);
        }
        catch (ReflectiveOperationException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = this.clientConfig::getKlass;
            log.error("Cannot instantiate Elasticsearch Client from class: {}", supplierArray);
            throw new NuxeoException((Throwable)e);
        }
        return ret;
    }

    protected void checkClusterHealth(String ... indexNames) {
        if (this.client == null) {
            throw new IllegalStateException("No Elasticsearch Client available");
        }
        this.client.waitForYellowStatus(indexNames, 30);
    }

    protected void initializeIndexes() {
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!conf.isDocumentIndex()) continue;
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = conf::getName;
            supplierArray[1] = conf::getRepositoryName;
            log.info("Associate index: {} with repository: {}", supplierArray);
            this.indexNames.put(conf.getRepositoryName(), conf.getName());
            this.repoNames.put(conf.getName(), conf.getRepositoryName());
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            if (this.includeSourceFields != null) {
                set.addAll(Arrays.asList(this.includeSourceFields));
            }
            set.addAll(Arrays.asList(conf.getIncludes()));
            if (set.contains("*")) {
                set.clear();
                set.add("*");
            }
            this.includeSourceFields = set.toArray(new String[0]);
            set.clear();
            if (this.excludeSourceFields != null) {
                set.addAll(Arrays.asList(this.excludeSourceFields));
            }
            set.addAll(Arrays.asList(conf.getExcludes()));
            this.excludeSourceFields = set.toArray(new String[0]);
        }
        this.initIndexes(false);
    }

    @Override
    public void refreshRepositoryIndex(String repositoryName) {
        log.debug("Refreshing index associated with repo: {}", (Object)repositoryName);
        this.getClient().refresh(this.getWriteIndexName(this.getIndexNameForRepository(repositoryName)));
        log.debug("Refreshing index done");
    }

    @Override
    public String getIndexNameForRepository(String repositoryName) {
        String ret = this.indexNames.get(repositoryName);
        if (ret == null) {
            throw new NoSuchElementException("No index defined for repository: " + repositoryName);
        }
        return ret;
    }

    @Override
    public String getRepositoryForIndex(String indexName) {
        return this.repoNames.get(indexName);
    }

    @Override
    public List<String> getIndexNamesForType(String type) {
        ArrayList<String> indexNames = new ArrayList<String>();
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!type.equals(conf.getType())) continue;
            indexNames.add(conf.getName());
        }
        return indexNames;
    }

    @Override
    public String getIndexNameForType(String type) {
        List<String> indexNames = this.getIndexNamesForType(type);
        if (indexNames.isEmpty()) {
            throw new NoSuchElementException("No index defined for type: " + type);
        }
        return indexNames.get(0);
    }

    @Override
    public String getWriteIndexName(String searchIndexName) {
        return this.writeIndexNames.getOrDefault(searchIndexName, searchIndexName);
    }

    @Override
    public void syncSearchAndWriteAlias(String searchIndexName) {
        ElasticSearchIndexConfig conf = this.indexConfig.values().stream().filter(item -> item.getName().equals(searchIndexName)).findFirst().orElseThrow(IllegalStateException::new);
        this.syncSearchAndWriteAlias(conf);
    }

    @Override
    public void flushRepositoryIndex(String repositoryName) {
        log.warn("Flushing index associated with repo: {}", (Object)repositoryName);
        this.getClient().flush(this.getWriteIndexName(this.getIndexNameForRepository(repositoryName)));
        log.info("Flushing index done");
    }

    @Override
    public void refresh() {
        for (String repositoryName : this.indexNames.keySet()) {
            this.refreshRepositoryIndex(repositoryName);
        }
    }

    @Override
    public void flush() {
        for (String repositoryName : this.indexNames.keySet()) {
            this.flushRepositoryIndex(repositoryName);
        }
    }

    @Override
    public void optimizeIndex(String indexName) {
        log.warn("Optimizing index: {}", (Object)indexName);
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!conf.getName().equals(indexName)) continue;
            this.getClient().optimize(indexName);
        }
        log.info("Optimize done");
    }

    @Override
    public void optimizeRepositoryIndex(String repositoryName) {
        this.optimizeIndex(this.getIndexNameForRepository(repositoryName));
    }

    @Override
    public void optimize() {
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            this.optimizeIndex(conf.getName());
        }
    }

    @Override
    public ESClient getClient() {
        return this.client;
    }

    @Override
    public void initIndexes(boolean dropIfExists) {
        this.indexInitDone = false;
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            this.initIndex(conf, dropIfExists);
        }
        log.info("Elasticsearch Service ready");
        this.indexInitDone = true;
    }

    @Override
    public void dropAndInitIndex(String indexName) {
        log.info("Drop and init index: {}", (Object)indexName);
        this.indexInitDone = false;
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!conf.getName().equals(indexName)) continue;
            this.initIndex(conf, true);
        }
        this.indexInitDone = true;
    }

    @Override
    public void dropAndInitRepositoryIndex(String repositoryName, boolean syncAlias) {
        log.info("Drop and init index of repository: {}", (Object)repositoryName);
        this.indexInitDone = false;
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!conf.isDocumentIndex() || !repositoryName.equals(conf.getRepositoryName())) continue;
            this.initIndex(conf, true, syncAlias);
        }
        this.indexInitDone = true;
    }

    @Override
    public List<String> getRepositoryNames() {
        return List.copyOf(this.indexNames.keySet());
    }

    protected void initIndex(ElasticSearchIndexConfig conf, boolean dropIfExists) {
        this.initIndex(conf, dropIfExists, true);
    }

    protected void initIndex(ElasticSearchIndexConfig conf, boolean dropIfExists, boolean syncAlias) {
        if (conf.manageAlias()) {
            this.initWriteAlias(conf, dropIfExists);
            this.initSearchAlias(conf);
            this.writeIndexNames.put(conf.getName(), conf.writeIndexOrAlias());
            if (syncAlias) {
                this.syncSearchAndWriteAlias(conf);
            }
        } else if (conf.hasExplicitWriteIndex()) {
            this.initIndex(conf.writeIndexOrAlias(), conf, dropIfExists);
            this.writeIndexNames.put(conf.getName(), conf.writeIndexOrAlias());
        } else {
            this.initIndex(conf.getName(), conf, dropIfExists);
            this.writeIndexNames.put(conf.getName(), conf.getName());
        }
    }

    protected void initWriteAlias(ElasticSearchIndexConfig conf, boolean dropIfExists) {
        String writeAlias = conf.writeIndexOrAlias();
        String writeIndex = this.getClient().getFirstIndexForAlias(writeAlias);
        String nextWriteIndex = conf.newWriteIndexForAlias(conf.getName(), writeIndex);
        if (writeIndex != null && !dropIfExists) {
            this.initIndex(writeIndex, conf, false);
        } else {
            if (this.getClient().indexExists(nextWriteIndex)) {
                throw new IllegalStateException(String.format("New index name %s for the alias %s already exists", nextWriteIndex, writeAlias));
            }
            this.initIndex(nextWriteIndex, conf, false);
            this.getClient().updateAlias(writeAlias, nextWriteIndex);
        }
    }

    protected void initSearchAlias(ElasticSearchIndexConfig conf) {
        String searchAlias = conf.getName();
        String searchIndex = this.getClient().getFirstIndexForAlias(searchAlias);
        String writeAlias = conf.writeIndexOrAlias();
        String writeIndex = this.getClient().getFirstIndexForAlias(writeAlias);
        if (searchIndex == null) {
            if (this.getClient().indexExists(searchAlias)) {
                if (Framework.isTestModeSet()) {
                    this.getClient().deleteIndex(searchAlias, 300);
                }
                searchIndex = searchAlias;
            } else {
                this.getClient().updateAlias(searchAlias, writeIndex);
                searchIndex = writeIndex;
            }
        }
        log.info("Managed index aliases: Alias: {} ->  index: {}, alias: {} ->  index: {}", (Object)searchAlias, (Object)searchIndex, (Object)writeAlias, (Object)writeIndex);
    }

    protected void syncSearchAndWriteAlias(ElasticSearchIndexConfig conf) {
        if (!conf.manageAlias()) {
            return;
        }
        String searchAlias = conf.getName();
        String searchIndex = this.getClient().getFirstIndexForAlias(searchAlias);
        String writeAlias = conf.writeIndexOrAlias();
        String writeIndex = this.getClient().getFirstIndexForAlias(writeAlias);
        if (!writeIndex.equals(searchIndex)) {
            log.warn("Updating search alias {} -> {} (previously {})", (Object)searchAlias, (Object)writeIndex, (Object)searchIndex);
            this.getClient().updateAlias(searchAlias, writeIndex);
            searchIndex = writeIndex;
        }
        this.repoNames.put(searchIndex, conf.getRepositoryName());
    }

    protected void initIndex(String indexName, ElasticSearchIndexConfig conf, boolean dropIfExists) {
        if (!conf.mustCreate()) {
            return;
        }
        log.info("Initialize index: {} with conf: {}, type: {}", (Object)indexName, (Object)conf.getName(), (Object)conf.getType());
        boolean mappingExists = false;
        boolean indexExists = this.getClient().indexExists(indexName);
        if (indexExists) {
            if (!dropIfExists) {
                String realIndexForAlias;
                log.debug("Index: {} already exists", (Object)indexName);
                mappingExists = this.getClient().mappingExists(indexName, conf.getType());
                if (conf.isDocumentIndex() && (realIndexForAlias = this.getClient().getFirstIndexForAlias(conf.getName())) != null) {
                    this.repoNames.put(realIndexForAlias, conf.getRepositoryName());
                }
            } else {
                if (!Framework.isTestModeSet()) {
                    log.warn("Initializing index: {}, type: {} with dropIfExists flag, deleting an existing index", (Object)indexName, (Object)conf.getType());
                }
                this.getClient().deleteIndex(indexName, 300);
                indexExists = false;
            }
        }
        if (!indexExists) {
            log.info("Creating index: {}", (Object)indexName);
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = conf::getSettings;
            log.debug("Using settings: {}", supplierArray);
            this.getClient().createIndex(indexName, conf.getSettings());
        }
        if (!mappingExists) {
            log.info("Creating mapping type: {} on index: {}", (Object)indexName, (Object)conf.getName());
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = conf::getMapping;
            log.debug("Using mapping: {}", supplierArray);
            this.getClient().createMapping(indexName, conf.getType(), conf.getMapping());
            if (!dropIfExists && conf.getRepositoryName() != null) {
                this.repositoryInitialized.add(conf.getRepositoryName());
            }
        }
        this.checkClusterHealth(indexName);
    }

    @Override
    public long getPendingWorkerCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public long getRunningWorkerCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getTotalCommandProcessed() {
        return this.totalCommandProcessed.get();
    }

    @Override
    public boolean isEmbedded() {
        return this.embeddedServer != null;
    }

    @Override
    public boolean useExternalVersion() {
        return this.clientConfig.useExternalVersion();
    }

    @Override
    public boolean isIndexingInProgress() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ListenableFuture<Boolean> prepareWaitForIndexing() {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected String[] getSearchIndexes(List<String> searchRepositories) {
        if (searchRepositories.isEmpty()) {
            Collection<String> values = this.indexNames.values();
            return values.toArray(new String[0]);
        }
        String[] ret = new String[searchRepositories.size()];
        int i = 0;
        for (String repo : searchRepositories) {
            ret[i++] = this.getIndexNameForRepository(repo);
        }
        return ret;
    }

    public boolean isReady() {
        return this.indexInitDone;
    }

    protected String[] getIncludeSourceFields() {
        return this.includeSourceFields;
    }

    protected String[] getExcludeSourceFields() {
        return this.excludeSourceFields;
    }

    protected Map<String, String> getRepositoryMap() {
        return this.repoNames;
    }

    public List<String> getInitializedRepositories() {
        return this.repositoryInitialized;
    }

    @Override
    public Optional<ESHintQueryBuilder> getHintByOperator(String name) {
        return Optional.ofNullable(this.hints.get(name));
    }
}

