/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.fetcher;

import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

public abstract class Fetcher {
    private final CoreSession session;
    private final SearchResponse response;
    private final Map<String, String> repoNames;

    public Fetcher(CoreSession session, SearchResponse response, Map<String, String> repoNames) {
        this.session = session;
        this.response = response;
        this.repoNames = repoNames;
    }

    protected CoreSession getSession() {
        return this.session;
    }

    protected SearchResponse getResponse() {
        return this.response;
    }

    protected String getRepoForIndex(String indexName) {
        if (this.repoNames == null) {
            return null;
        }
        return this.repoNames.get(indexName);
    }

    public abstract DocumentModelListImpl fetchDocuments();
}

