/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.bulk.BulkActionDescriptor;
import org.nuxeo.ecm.core.bulk.BulkActionValidation;
import org.nuxeo.ecm.core.bulk.BulkAdminService;
import org.nuxeo.lib.stream.computation.StreamManager;
import org.nuxeo.lib.stream.computation.StreamProcessor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.Descriptor;
import org.nuxeo.runtime.stream.StreamService;

public class BulkAdminServiceImpl
implements BulkAdminService {
    public static final String SCROLLER_NAME = "scroller";
    public static final String STATUS_NAME = "status";
    public static final String BULK_SERVICE_PROCESSOR_NAME = "bulkServiceProcessor";
    public static final String BULK_SCROLL_SIZE_PROPERTY = "nuxeo.core.bulk.scroller.scroll.size";
    public static final String BULK_SCROLL_KEEP_ALIVE_PROPERTY = "nuxeo.core.bulk.scroller.scroll.keepAliveSeconds";
    public static final String BULK_SCROLL_PRODUCE_IMMEDIATE_PROPERTY = "nuxeo.core.bulk.scroller.produceImmediate";
    public static final int DEFAULT_SCROLL_SIZE = 100;
    public static final int DEFAULT_SCROLL_KEEP_ALIVE = 60;
    public static final Duration STOP_DURATION = Duration.ofSeconds(1L);
    protected final Map<String, BulkActionDescriptor> descriptors;
    protected final List<String> actions;
    protected StreamProcessor streamProcessor;
    protected Map<String, BulkActionValidation> actionValidations;

    public BulkAdminServiceImpl(List<BulkActionDescriptor> descriptorsList) {
        this.actions = descriptorsList.stream().map(Descriptor::getId).collect(Collectors.toList());
        this.descriptors = new HashMap<String, BulkActionDescriptor>(descriptorsList.size());
        descriptorsList.forEach(descriptor -> this.descriptors.put(descriptor.name, (BulkActionDescriptor)descriptor));
        this.actionValidations = descriptorsList.stream().collect(HashMap::new, (map, desc) -> map.put(desc.name, desc.validationClass != null ? desc.newValidationInstance() : null), HashMap::putAll);
    }

    @Override
    public List<String> getActions() {
        return this.actions;
    }

    @Override
    public int getBucketSize(String action) {
        return this.descriptors.get(action).getBucketSize();
    }

    @Override
    public int getBatchSize(String action) {
        return this.descriptors.get(action).getBatchSize();
    }

    @Override
    public String getDefaultScroller(String action) {
        return this.descriptors.get(action).getDefaultScroller();
    }

    @Override
    public boolean isHttpEnabled(String actionId) {
        return this.descriptors.get((Object)actionId).httpEnabled;
    }

    @Override
    public boolean isSequentialCommands(String actionId) {
        return this.descriptors.get((Object)actionId).sequentialCommands;
    }

    @Override
    public BulkActionValidation getActionValidation(String action) {
        return this.actionValidations.get(action);
    }

    public void afterStart() {
        StreamManager manager = ((StreamService)Framework.getService(StreamService.class)).getStreamManager("bulk");
        this.streamProcessor = manager.createStreamProcessor(BULK_SERVICE_PROCESSOR_NAME);
        this.streamProcessor.start();
    }

    public void beforeStop() {
        if (this.streamProcessor != null) {
            this.streamProcessor.stop(STOP_DURATION);
        }
    }
}

