/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.action.computation;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractTransientBlobComputation;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.bulk.message.DataBucket;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;

public class ExposeBlob
extends AbstractTransientBlobComputation {
    public static final String NAME = "exposeBlob";

    public ExposeBlob() {
        super(NAME);
    }

    public void processRecord(ComputationContext context, String documentIdsStreamName, Record record) {
        Codec<DataBucket> codec = BulkCodecs.getDataBucketCodec();
        DataBucket in = (DataBucket)codec.decode(record.getData());
        String commandId = in.getCommandId();
        long documents = in.getCount();
        String storeName = ((BulkStatus)((BulkService)Framework.getService(BulkService.class)).getStatus((Serializable)((Object)commandId))).getAction();
        Blob blob = this.getBlob(in.getDataAsString(), storeName);
        TransientStore store = ((TransientStoreService)Framework.getService(TransientStoreService.class)).getStore("download");
        store.putBlobs(commandId, Collections.singletonList(blob));
        store.setCompleted(commandId, true);
        BulkStatus delta = BulkStatus.deltaOf(commandId);
        delta.setProcessed(documents);
        String url = ((DownloadService)Framework.getService(DownloadService.class)).getDownloadUrl(commandId);
        Map<String, String> result = Collections.singletonMap("url", url);
        delta.setResult(result);
        AbstractBulkComputation.updateStatus(context, delta);
        context.askForCheckpoint();
    }
}

