/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scroll;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.ecm.core.api.scroll.Scroll;
import org.nuxeo.ecm.core.api.scroll.ScrollRequest;
import org.nuxeo.ecm.core.api.scroll.ScrollService;
import org.nuxeo.ecm.core.scroll.ScrollDescriptor;

public class ScrollServiceImpl
implements ScrollService {
    protected static final String SEP_KEY = ":";
    protected static final String DEFAULT_NAME = "default";
    protected final Map<String, ScrollDescriptor> descriptors;

    public ScrollServiceImpl(List<ScrollDescriptor> scrollDescriptors) {
        this.descriptors = new HashMap<String, ScrollDescriptor>(scrollDescriptors.size());
        scrollDescriptors.forEach(descriptor -> this.descriptors.put(this.getKey((ScrollDescriptor)descriptor), (ScrollDescriptor)descriptor));
        scrollDescriptors.stream().filter(ScrollDescriptor::isDefault).forEach(descriptor -> this.descriptors.put(this.getDefaultKey((ScrollDescriptor)descriptor), (ScrollDescriptor)descriptor));
    }

    protected String getKey(ScrollDescriptor descriptor) {
        return this.getKey(descriptor.getType(), descriptor.getName());
    }

    protected String getDefaultKey(ScrollDescriptor descriptor) {
        return this.getKey(descriptor.getType(), DEFAULT_NAME);
    }

    protected String getKey(ScrollRequest request) {
        return this.getKey(request.getType(), request.getName() == null ? DEFAULT_NAME : request.getName());
    }

    protected String getKey(String type, String name) {
        return type + SEP_KEY + name;
    }

    public Scroll scroll(ScrollRequest request) {
        Objects.requireNonNull(request);
        ScrollDescriptor descriptor = this.descriptors.get(this.getKey(request));
        if (descriptor == null) {
            throw new IllegalArgumentException("Unknown Scroll " + this.getKey(request) + " implementation for request: " + request);
        }
        Scroll scroll = descriptor.newScrollInstance();
        scroll.init(request, descriptor.getOptions());
        return scroll;
    }

    public boolean exists(ScrollRequest request) {
        if (request == null) {
            return false;
        }
        return this.descriptors.containsKey(this.getKey(request));
    }
}

