/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.jaxrs.io.operations.ExecutionRequest;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.automation.server.jaxrs.RestOperationException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

public abstract class ExecutableResource
extends DefaultObject {
    @Context
    protected AutomationService service;
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;
    @Context
    protected CoreSession session;

    protected OperationContext createContext(ExecutionRequest xreq) {
        return xreq.createContext(this.request, this.response, this.session);
    }

    @POST
    public Object doPost(ExecutionRequest xreq) {
        try {
            AutomationServer srv = (AutomationServer)Framework.getService(AutomationServer.class);
            if (!srv.accept(this.getId(), this.isChain(), this.request)) {
                return ResponseHelper.notFound();
            }
            Object result = this.execute(xreq);
            int customHttpStatus = xreq.getRestOperationContext().getHttpStatus();
            return ResponseHelper.getResponse(result, this.request, customHttpStatus);
        }
        catch (IOException | MessagingException | OperationException | NuxeoException cause) {
            String exceptionMessage = "Failed to invoke operation: " + this.getId();
            if (cause instanceof OperationNotFoundException) {
                throw new WebResourceNotFoundException(exceptionMessage, cause);
            }
            if (cause instanceof NuxeoException) {
                NuxeoException nuxeoException = (NuxeoException)cause;
                nuxeoException.addInfo(exceptionMessage);
                throw nuxeoException;
            }
            Throwable unWrapException = ExceptionHelper.unwrapException((Throwable)cause);
            if (unWrapException instanceof RestOperationException) {
                int customHttpStatus = ((RestOperationException)((Object)unWrapException)).getStatus();
                throw new NuxeoException(exceptionMessage, cause, customHttpStatus);
            }
            throw new NuxeoException(exceptionMessage, cause);
        }
    }

    public abstract String getId();

    public abstract Object execute(ExecutionRequest var1) throws OperationException;

    public abstract boolean isChain();
}

