/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.forms.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.webengine.forms.validation.Form;

public class ValidationException
extends Exception {
    private static final long serialVersionUID = 531665422854150881L;
    public static final String IS_REQUIRED_MSG = "is required";
    public static final String IS_INVALID_MSG = "is invalid";
    protected Map<String, String> invalidFields = new HashMap<String, String>();
    protected Map<String, String> requiredFields = new HashMap<String, String>();
    protected transient Form form;

    public ValidationException(String message) {
        super(message);
    }

    public ValidationException(String message, Throwable cause) {
        super(message, cause);
    }

    public ValidationException() {
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null) {
            String msg;
            StringBuilder buf = new StringBuilder();
            if (this.hasRequiredFields()) {
                for (Map.Entry<String, String> entry : this.requiredFields.entrySet()) {
                    msg = entry.getValue();
                    buf.append(entry.getKey()).append(": ").append(msg == null ? IS_REQUIRED_MSG : msg).append("\n");
                }
            }
            if (this.hasInvalidFields()) {
                for (Map.Entry<String, String> entry : this.invalidFields.entrySet()) {
                    msg = entry.getValue();
                    buf.append(entry.getKey()).append(": ").append(msg == null ? IS_INVALID_MSG : msg).append("\n");
                }
            }
            return buf.toString();
        }
        return message;
    }

    public String getXmlMessage() {
        String message = super.getMessage();
        if (message == null) {
            String msg;
            StringBuilder buf = new StringBuilder();
            if (this.hasRequiredFields()) {
                for (Map.Entry<String, String> entry : this.requiredFields.entrySet()) {
                    msg = entry.getValue();
                    buf.append("<li>").append(entry.getKey()).append(": ").append(msg == null ? IS_REQUIRED_MSG : msg);
                }
            }
            if (this.hasInvalidFields()) {
                for (Map.Entry<String, String> entry : this.invalidFields.entrySet()) {
                    msg = entry.getValue();
                    buf.append("<li>").append(entry.getKey()).append(": ").append(msg == null ? IS_INVALID_MSG : msg);
                }
            }
            return buf.toString();
        }
        return message;
    }

    public ValidationException addRequiredField(String key) {
        this.requiredFields.put(key, null);
        return this;
    }

    public ValidationException addRequiredField(String key, String message) {
        this.requiredFields.put(key, message);
        return this;
    }

    public ValidationException addInvalidField(String key) {
        this.invalidFields.put(key, null);
        return this;
    }

    public ValidationException addInvalidField(String key, String message) {
        this.invalidFields.put(key, message);
        return this;
    }

    public boolean hasFieldErrors() {
        return !this.requiredFields.isEmpty() || !this.invalidFields.isEmpty();
    }

    public boolean hasInvalidFields() {
        return !this.invalidFields.isEmpty();
    }

    public boolean hasRequiredFields() {
        return !this.requiredFields.isEmpty();
    }

    public Collection<String> getRequiredFields() {
        return this.requiredFields.keySet();
    }

    public Collection<String> getInvalidFields() {
        return this.invalidFields.keySet();
    }

    public boolean hasErrors(String key) {
        return this.requiredFields.containsKey(key) || this.invalidFields.containsKey(key);
    }

    public String getError(String key) {
        String message = this.requiredFields.get(key);
        return message == null ? this.invalidFields.get(key) : message;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public Form getForm() {
        return this.form;
    }
}

