/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.io;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.JSONBlob;
import org.nuxeo.ecm.core.io.download.BufferingServletOutputStream;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Provider
@Produces(value={"*/*", "text/plain"})
public class BlobWriter
implements MessageBodyWriter<Blob> {
    private static final Log log = LogFactory.getLog(BlobWriter.class);
    public static final String BLOB_ID = "blobId";
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    @Context
    private ServletContext servletContext;

    public void writeTo(Blob blob, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        this.commitAndReopenTransaction();
        httpHeaders.clear();
        if (Framework.isTestModeSet()) {
            String filename = blob.getFilename();
            if (filename != null) {
                String contentDisposition = DownloadHelper.getRFC2231ContentDisposition((HttpServletRequest)this.request, (String)filename);
                this.response.setHeader("Content-Disposition", contentDisposition);
            }
            this.response.setContentType(blob.getMimeType());
            if (blob.getEncoding() != null) {
                try {
                    this.response.setCharacterEncoding(blob.getEncoding());
                }
                catch (IllegalArgumentException contentDisposition) {
                    // empty catch block
                }
            }
            this.transferBlob(blob, entityStream);
        } else {
            String reason = blob instanceof JSONBlob ? "webengine" : "download";
            DownloadService.DownloadContext context = DownloadService.DownloadContext.builder((HttpServletRequest)this.request, (HttpServletResponse)this.response).blob(blob).reason(reason).build();
            ((DownloadService)Framework.getService(DownloadService.class)).downloadBlob(context);
        }
    }

    protected void commitAndReopenTransaction() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    protected void transferBlob(Blob blob, OutputStream entityStream) throws IOException {
        if (entityStream instanceof BufferingServletOutputStream) {
            ((BufferingServletOutputStream)entityStream).stopBuffering();
        }
        blob.transferTo(entityStream);
        entityStream.flush();
    }

    public long getSize(Blob arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        long n = arg0.getLength();
        return n <= 0L ? -1L : n;
    }

    public boolean isWriteable(Class<?> arg0, Type type, Annotation[] arg2, MediaType arg3) {
        return Blob.class.isAssignableFrom(arg0);
    }
}

