/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLink;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLinkComputer;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginScreenConfig;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginStartupPage;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class LoginScreenHelper {
    protected static final Log log = LogFactory.getLog(LoginScreenHelper.class);
    public static final String DEFAULT_STARTUP_PAGE_PATH = "home.html";

    private LoginScreenHelper() {
    }

    public static LoginScreenConfig getConfig() {
        PluggableAuthenticationService authenticationService = LoginScreenHelper.getPluggableAuthenticationService();
        return authenticationService == null ? null : authenticationService.getLoginScreenConfig();
    }

    public static LoginScreenConfig registerSingleProviderLoginScreenConfig(String name, String iconUrl, String link, String label, String description, LoginProviderLinkComputer computer) {
        LoginProviderLink provider = new LoginProviderLink(name, iconUrl, link, label, description, computer);
        LoginScreenConfig config = new LoginScreenConfig(provider);
        LoginScreenHelper.getPluggableAuthenticationService().registerLoginScreenConfig(config);
        return config;
    }

    public static void unregisterLoginScreenConfig(LoginScreenConfig config) {
        LoginScreenHelper.getPluggableAuthenticationService().unregisterLoginScreenConfig(config);
    }

    @Deprecated
    public static void registerLoginProvider(String name, String iconUrl, String link, String label, String description, LoginProviderLinkComputer computer) {
        LoginScreenHelper.registerSingleProviderLoginScreenConfig(name, iconUrl, link, label, description, computer);
    }

    public static String getValueWithDefault(String value, String defaultValue) {
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    public static String getStartupPageURL(HttpServletRequest request) {
        return VirtualHostHelper.getBaseURL((ServletRequest)request) + LoginScreenHelper.getStartupPagePath();
    }

    public static String getStartupPagePath() {
        LoginScreenConfig config = LoginScreenHelper.getConfig();
        if (config == null) {
            log.debug((Object)"No <loginScreenConfig> contribution found, startup page path = home.html");
            return DEFAULT_STARTUP_PAGE_PATH;
        }
        LoginStartupPage defaultStartupPage = LoginScreenHelper.getDefaultStartupPage(config);
        log.debug((Object)("Default <startupPage> contribution: " + defaultStartupPage));
        if (defaultStartupPage == null) {
            log.debug((Object)"No <startupPage> contribution found, startup page path = home.html");
            return DEFAULT_STARTUP_PAGE_PATH;
        }
        String startupPagePath = defaultStartupPage.getPath();
        if (startupPagePath.startsWith("/")) {
            startupPagePath = startupPagePath.substring(1);
        }
        log.debug((Object)("Startup page path = " + startupPagePath));
        return startupPagePath;
    }

    public static List<String> getStartupPagePaths() {
        LoginScreenConfig config = LoginScreenHelper.getConfig();
        if (config == null) {
            return Collections.emptyList();
        }
        return config.getStartupPages().values().stream().sorted((p1, p2) -> p2.compareTo((LoginStartupPage)p1)).map(LoginStartupPage::getPath).collect(Collectors.toList());
    }

    protected static LoginStartupPage getDefaultStartupPage(LoginScreenConfig config) {
        if (config.getStartupPages().isEmpty()) {
            return null;
        }
        return Collections.max(config.getStartupPages().values());
    }

    protected static PluggableAuthenticationService getPluggableAuthenticationService() {
        return (PluggableAuthenticationService)((Object)Framework.getService(PluggableAuthenticationService.class));
    }
}

