/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.List;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.InverseReferenceDescriptor;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;

public class InverseReference
extends AbstractReference {
    protected boolean readOnly = false;
    protected String dualReferenceName;
    protected Reference dualReference;

    public InverseReference(InverseReferenceDescriptor referenceDescriptor) {
        super(referenceDescriptor.getFieldName(), referenceDescriptor.getDirectory());
        this.dualReferenceName = referenceDescriptor.getDualReferenceName();
        this.readOnly = referenceDescriptor.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void initialize() {
        List references = this.getTargetDirectory().getReferences(this.dualReferenceName);
        if (references == null || references.isEmpty()) {
            this.dualReference = null;
        } else if (references.size() == 1) {
            this.dualReference = (Reference)references.get(0);
        } else {
            for (Reference ref : references) {
                if (ref instanceof InverseReference || !this.sourceDirectoryName.equals(ref.getTargetDirectory().getName()) || !this.targetDirectoryName.equals(ref.getSourceDirectory().getName())) continue;
                if (this.dualReference != null) {
                    throw new DirectoryException("More than one reference: could not find reference " + this.dualReferenceName);
                }
                this.dualReference = ref;
            }
        }
        if (this.dualReference == null) {
            throw new DirectoryException("could not find reference " + this.dualReferenceName);
        }
        if (this.dualReference instanceof InverseReference) {
            throw new DirectoryException(String.format("InverseReference %s cannot refer to InverseReference %s", this.getFieldName(), this.dualReferenceName));
        }
    }

    public void addLinks(String sourceId, List<String> targetIds) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.addLinks(targetIds, sourceId);
    }

    public void addLinks(List<String> sourceIds, String targetId) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.addLinks(targetId, sourceIds);
    }

    public void removeLinksForTarget(String targetId) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.removeLinksForSource(targetId);
    }

    public void removeLinksForTarget(String targetId, Session session) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.removeLinksForSource(targetId, session);
    }

    public void removeLinksForSource(String sourceId) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.removeLinksForTarget(sourceId);
    }

    public void removeLinksForSource(String sourceId, Session session) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.removeLinksForTarget(sourceId, session);
    }

    public List<String> getSourceIdsForTarget(String targetId) {
        return this.dualReference.getTargetIdsForSource(targetId);
    }

    public List<String> getTargetIdsForSource(String sourceId) {
        return this.dualReference.getSourceIdsForTarget(sourceId);
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.setSourceIdsForTarget(sourceId, targetIds);
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds, Session session) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.setSourceIdsForTarget(sourceId, targetIds, session);
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.setTargetIdsForSource(targetId, sourceIds);
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds, Session session) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.setTargetIdsForSource(targetId, sourceIds, session);
    }

    public void addLinks(String sourceId, List<String> targetIds, Session session) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.addLinks(targetIds, sourceId, session);
    }

    public void addLinks(List<String> sourceIds, String targetId, Session session) {
        if (this.readOnly) {
            return;
        }
        this.dualReference.addLinks(targetId, sourceIds, session);
    }
}

