/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

public abstract class RedisAbstractExecutor
implements RedisExecutor {
    private static final String ERROR_PREFIX_NOSCRIPT = "NOSCRIPT";
    protected Map<String, String> scripts = new HashMap<String, String>();

    @Override
    public String scriptLoad(String script) throws JedisException {
        String sha1 = this.execute(jedis -> jedis.scriptLoad(script));
        this.scripts.put(sha1, script);
        return sha1;
    }

    @Override
    public Object evalsha(String sha1, List<String> keys, List<String> args) throws JedisException {
        try {
            return this.execute(jedis -> jedis.evalsha(sha1, keys, args));
        }
        catch (JedisDataException e) {
            if (!e.getMessage().startsWith(ERROR_PREFIX_NOSCRIPT)) {
                throw e;
            }
            String script = this.scripts.get(new String(sha1));
            if (script == null) {
                throw e;
            }
            this.execute(jedis -> jedis.scriptLoad(script));
            return this.execute(jedis -> jedis.evalsha(sha1, keys, args));
        }
    }

    @Override
    public Object evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args) throws JedisException {
        try {
            return this.execute(jedis -> jedis.evalsha(sha1, keys, args));
        }
        catch (JedisDataException e) {
            if (!e.getMessage().startsWith(ERROR_PREFIX_NOSCRIPT)) {
                throw e;
            }
            String script = this.scripts.get(new String(sha1));
            if (script == null) {
                throw e;
            }
            this.execute(jedis -> jedis.scriptLoad(script));
            return this.execute(jedis -> jedis.evalsha(sha1, keys, args));
        }
    }
}

