/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.util.List;
import org.nuxeo.ecm.core.redis.RedisCallable;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.Pool;

public interface RedisExecutor {
    public String scriptLoad(String var1) throws JedisException;

    public Object evalsha(String var1, List<String> var2, List<String> var3) throws JedisException;

    public Object evalsha(byte[] var1, List<byte[]> var2, List<byte[]> var3) throws JedisException;

    public <T> T execute(RedisCallable<T> var1) throws JedisException;

    default public void subscribe(JedisPubSub subscriber, String channel) throws JedisException {
        this.execute(jedis -> {
            jedis.subscribe(subscriber, new String[]{channel});
            return null;
        });
    }

    default public void psubscribe(JedisPubSub subscriber, String ... patterns) throws JedisException {
        this.execute(jedis -> {
            jedis.psubscribe(subscriber, patterns);
            return null;
        });
    }

    public Pool<Jedis> getPool();

    default public void startMonitor() {
    }

    default public void stopMonitor() {
    }
}

