/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;

public class ComponentRegistry {
    private final Logger log = LogManager.getLogger(ComponentRegistry.class);
    protected Map<ComponentName, RegistrationInfo> components;
    protected LinkedHashMap<ComponentName, RegistrationInfo> resolved;
    protected Map<ComponentName, ComponentName> aliases;
    protected MappedSet requirements;
    protected MappedSet pendings;
    protected Map<String, ComponentName> deployedFiles;

    public ComponentRegistry() {
        this.components = new HashMap<ComponentName, RegistrationInfo>();
        this.aliases = new HashMap<ComponentName, ComponentName>();
        this.requirements = new MappedSet();
        this.pendings = new MappedSet();
        this.resolved = new LinkedHashMap();
        this.deployedFiles = new HashMap<String, ComponentName>();
    }

    public ComponentRegistry(ComponentRegistry reg) {
        this.components = new HashMap<ComponentName, RegistrationInfo>(reg.components);
        this.aliases = new HashMap<ComponentName, ComponentName>(reg.aliases);
        this.requirements = new MappedSet(reg.requirements);
        this.pendings = new MappedSet(reg.pendings);
        this.resolved = new LinkedHashMap<ComponentName, RegistrationInfo>(reg.resolved);
        this.deployedFiles = new HashMap<String, ComponentName>(reg.deployedFiles);
    }

    public synchronized void destroy() {
        this.components = null;
        this.aliases = null;
        this.requirements = null;
        this.pendings = null;
        this.deployedFiles = null;
    }

    public final synchronized boolean isResolved(ComponentName name) {
        RegistrationInfo ri = this.components.get(this.unaliased(name));
        if (ri == null) {
            return false;
        }
        return ri.getState() > 1;
    }

    public synchronized boolean addComponent(RegistrationInfo ri) {
        ComponentName name = ri.getName();
        Set<ComponentName> al = ri.getAliases();
        this.log.trace("Registering component: {}{}", new Supplier[]{() -> name, () -> al.isEmpty() ? "" : ", aliases=" + al});
        if (ri.useFormerLifecycleManagement()) {
            ((RegistrationInfoImpl)ri).register();
        } else {
            ri.setState(1);
        }
        String sourceId = ri.getSourceId();
        if (sourceId != null) {
            this.deployedFiles.put(sourceId, ri.getName());
        }
        this.components.put(name, ri);
        for (ComponentName n : al) {
            this.aliases.put(n, name);
        }
        boolean hasUnresolvedDependencies = this.computePendings(ri);
        if (!hasUnresolvedDependencies) {
            this.resolveComponent(ri);
            return true;
        }
        return false;
    }

    public synchronized RegistrationInfo removeComponent(ComponentName name) {
        RegistrationInfo ri = this.components.remove(name);
        if (ri != null) {
            try {
                this.unresolveComponent(ri);
            }
            finally {
                if (ri.useFormerLifecycleManagement()) {
                    ((RegistrationInfoImpl)ri).unregister();
                } else {
                    ri.setState(0);
                }
            }
        }
        return ri;
    }

    public synchronized Collection<RegistrationInfo> getResolvedRegistrationInfo() {
        return Collections.unmodifiableCollection(this.resolved.values());
    }

    public synchronized Collection<ComponentName> getResolvedNames() {
        return Collections.unmodifiableCollection(this.resolved.keySet());
    }

    public synchronized Set<ComponentName> getMissingDependencies(ComponentName name) {
        return Collections.unmodifiableSet(this.pendings.get(name));
    }

    public synchronized RegistrationInfo getComponent(ComponentName name) {
        return this.components.get(this.unaliased(name));
    }

    public synchronized boolean contains(ComponentName name) {
        return this.components.containsKey(this.unaliased(name));
    }

    public synchronized int size() {
        return this.components.size();
    }

    public synchronized Collection<RegistrationInfo> getComponents() {
        return Collections.unmodifiableCollection(this.components.values());
    }

    public synchronized RegistrationInfo[] getComponentsArray() {
        return this.components.values().toArray(new RegistrationInfo[0]);
    }

    public synchronized Map<ComponentName, Set<ComponentName>> getPendingComponents() {
        return Collections.unmodifiableMap(this.pendings.map);
    }

    protected ComponentName unaliased(ComponentName name) {
        ComponentName alias = this.aliases.get(name);
        return alias == null ? name : alias;
    }

    protected final boolean computePendings(RegistrationInfo ri) {
        Set<ComponentName> set = ri.getRequiredComponents();
        if (set == null || set.isEmpty()) {
            return false;
        }
        boolean hasUnresolvedDependencies = false;
        for (ComponentName name : set) {
            if (!this.isResolved(name)) {
                this.pendings.put(ri.getName(), name);
                hasUnresolvedDependencies = true;
            }
            this.requirements.put(name, ri.getName());
        }
        return hasUnresolvedDependencies;
    }

    protected void resolveComponent(RegistrationInfo ri) {
        ComponentName riName = ri.getName();
        HashSet<ComponentName> names = new HashSet<ComponentName>();
        names.add(riName);
        names.addAll(ri.getAliases());
        if (ri.useFormerLifecycleManagement()) {
            ((RegistrationInfoImpl)ri).resolve();
        } else {
            ri.setState(2);
        }
        this.resolved.put(ri.getName(), ri);
        HashSet<ComponentName> dependsOnMe = new HashSet<ComponentName>();
        for (ComponentName n : names) {
            Set<ComponentName> reqs = this.requirements.get(n);
            if (reqs == null) continue;
            dependsOnMe.addAll(reqs);
        }
        if (dependsOnMe.isEmpty()) {
            return;
        }
        for (ComponentName name : dependsOnMe) {
            for (ComponentName n : names) {
                this.pendings.remove(name, n);
            }
            Set<ComponentName> set = this.pendings.get(name);
            if (set != null && !set.isEmpty()) continue;
            RegistrationInfo waitingRi = this.components.get(name);
            this.resolveComponent(waitingRi);
        }
    }

    protected void unresolveComponent(RegistrationInfo ri) {
        Set<ComponentName> set;
        Set<ComponentName> reqs = ri.getRequiredComponents();
        ComponentName name = ri.getName();
        if (ri.useFormerLifecycleManagement()) {
            ((RegistrationInfoImpl)ri).unresolve();
        } else {
            ri.setState(1);
        }
        this.resolved.remove(name);
        this.pendings.remove(name);
        if (reqs != null) {
            for (ComponentName req : reqs) {
                this.requirements.remove(req, name);
            }
        }
        if ((set = this.requirements.get(name)) != null && !set.isEmpty()) {
            for (ComponentName dep : set.toArray(new ComponentName[0])) {
                RegistrationInfo depRi = this.components.get(dep);
                if (depRi == null) continue;
                this.unresolveComponent(depRi);
            }
        }
    }

    protected static class MappedSet {
        protected Map<ComponentName, Set<ComponentName>> map = new HashMap<ComponentName, Set<ComponentName>>();

        public MappedSet() {
        }

        public MappedSet(MappedSet mset) {
            this();
            for (Map.Entry<ComponentName, Set<ComponentName>> entry : mset.map.entrySet()) {
                ComponentName name = entry.getKey();
                Set<ComponentName> set = entry.getValue();
                HashSet<ComponentName> newSet = new HashSet<ComponentName>(set);
                this.map.put(name, newSet);
            }
        }

        public Set<ComponentName> get(ComponentName name) {
            return this.map.get(name);
        }

        public Set<ComponentName> put(ComponentName key, ComponentName value) {
            Set set = this.map.computeIfAbsent(key, k -> new HashSet());
            set.add(value);
            return set;
        }

        public Set<ComponentName> remove(ComponentName key) {
            return this.map.remove(key);
        }

        public Set<ComponentName> remove(ComponentName key, ComponentName value) {
            Set<ComponentName> set = this.map.get(key);
            if (set != null) {
                set.remove(value);
                if (set.isEmpty()) {
                    this.map.remove(key);
                }
            }
            return set;
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public int size() {
            return this.map.size();
        }

        public void clear() {
            this.map.clear();
        }
    }
}

