/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.convert;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.runtime.api.Framework;

public class ScreenshotConverter
implements Converter {
    public static final Log log = LogFactory.getLog(ScreenshotConverter.class);
    public static final String FFMPEG_SCREENSHOT_COMMAND = "ffmpeg-screenshot";

    public void init(ConverterDescriptor descriptor) {
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        SimpleCachableBlobHolder simpleCachableBlobHolder;
        block11: {
            Blob blob = blobHolder.getBlob();
            if (blob == null) {
                throw new ConversionException("conversion failed (null blob)");
            }
            CloseableFile source = blob.getCloseableFile("." + FilenameUtils.getExtension((String)blob.getFilename()));
            try {
                Blob outBlob = Blobs.createBlobWithExtension((String)".jpeg");
                CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
                CmdParameters params = cles.getDefaultCmdParameters();
                params.addNamedParameter("inFilePath", source.getFile().getAbsolutePath());
                params.addNamedParameter("outFilePath", outBlob.getFile().getAbsolutePath());
                Double position = 0.0;
                if (parameters != null && (position = (Double)parameters.get("position")) == null) {
                    position = 0.0;
                }
                long positionParam = Math.round(position);
                params.addNamedParameter("position", String.valueOf(positionParam));
                ExecResult res = cles.execCommand(FFMPEG_SCREENSHOT_COMMAND, params);
                if (!res.isSuccessful()) {
                    throw res.getError();
                }
                outBlob.setMimeType("image/jpeg");
                outBlob.setFilename(String.format("video-screenshot-%05d.000.jpeg", positionParam));
                simpleCachableBlobHolder = new SimpleCachableBlobHolder(outBlob);
                if (source == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CommandException | CommandNotAvailable e) {
                    throw new ConversionException("error extracting screenshot from '" + blob.getFilename() + "'", e);
                }
            }
            source.close();
        }
        return simpleCachableBlobHolder;
    }
}

